/*
 *  EVNT_MESAG					(C) Digital Design 1990
 *
 *  AES wartet, bis eine Nachricht im Ereignispuffer vorliegt.
 *  Mit Hilfe dieses Befehles werden Fenstermanipulationen sowie die
 *  Interaktion des Benutzers mit der Menleiste berwacht.
 */
#include <gemdefs.h>

int evnt_mesag( int *ev_mgpbuff )
{
  addrin[0] = ev_mgpbuff; /* Adresse des 16 Bytes groen Speicherbe-	*
			   * reichs, in dem die Nachricht abgelegt wer- *
			   * den soll (message pipe).			*
			   * Die ersten 3 Wrter des Puffers werden von *
			   * AES unabhngig vom Typ des aufgetretenen	*
			   * Ereignisses belegt:			*
			   *						*
			   * Wort 0: Eine Nummer zur Erkennung des	*
			   *	     Ereignisses.			*
			   * Wort 1: apid (Applikationskennziffer) der	*
			   *	     Applikation, die fr das Auftreten *
			   *	     des Ereignisses verantwortlich ist.*
			   * Wort 2: Die Lnge der Nachricht ohne Be-	*
			   *	     rcksichtigung der 16-Byte-Grenze. *
			   *	     Falls Wort 2 gleich Null ist, ist	*
			   *	     die Nachricht krzer als 16 Bytes, *
			   *	     ansonsten gibt Wort 2 die Lnge	*
			   *	     minus 16 Bytes an. In diesem Fall	*
			   *	     sollten Sie unbedingt von der	*
			   *	     Funktion APPL_READ..\APPL\APPL_REA.C Gebrauch machen.*
			   *						*
			   * Folgende Ereignisse werden im Pipeline-	*
			   * Puffer festgehalten:			*
			   *						*
			   * MN_SELECTED:				*
			   *						*
			   * Dieses Ereignis signalisiert, da der Be-	*
			   * nutzer einen Punkt aus dem Drop-Down-Men	*
			   * gewhlt hat.				*
			   *  Wort 0 = 10				*
			   *  Wort 3 = Object-Index des Men-Titels	*
			   *  Wort 4 = Object-Index des Men-Eintrags	*
			   *						*
			   * WM_REDRAW: 				*
			   *						*
			   * Der Benutzer hat einen Schritt durchge-	*
			   * fhrt, der das Neuzeichnen eines bestimm-	*
			   * ten Bildschirmbereichs erforderlich macht, *
			   * wenn beispielsweise ein Bearbeitungsformu- *
			   * lar wieder vom Bildschirm gelscht werden	*
			   * soll.					*
			   *  Wort 0 = 20				*
			   *  Wort 3 = Window Handle (Fensterkennziffer)*
			   *  Wort 4 = X-Koordinate des neu zu zeich-	*
			   *	       nenden Bereichs			*
			   *  Wort 5 = Y-Koordinate des neu zu zeich-	*
			   *	       nenden Bereichs			*
			   *  Wort 6 = Breite des neu zu zeichnenden	*
			   *	       Bereichs 			*
			   *  Wort 7 = Hhe des neu zu zeichnenden	*
			   *	       Bereichs 			*
			   *						*
			   * WM_TOPPED: 				*
			   *						*
			   * Der Benutzer mchte ein Fenster aktivieren.*
			   * Nur ein aktives Fenster gleichzeitig ist	*
			   * mglich. Dieses kann in Gre und Position *
			   * verndert werden.				*
			   *  Wort 0 = 21				*
			   *  Wort 3 = Window Handle			*
			   *						*
			   * WM_CLOSED: 				*
			   *						*
			   * Der Benutzer hat das Lschfeld (= Schlie- *
			   * feld, engl. close box) des aktiven 	*
			   * Fensters angeklickt, um es zu lschen.	*
			   *  Wort 0 = 22				*
			   *  Wort 3 = Window Handle			*
			   *						*
			   * WM_FULLED: 				*
			   *						*
			   * Der Benutzer hat das Bildschirmformatfeld	*
			   * (Vollfeld, engl. full box) angeklickt, um	*
			   * das aktive Fenster auf Bildschirmformat zu *
			   * vergrern oder wieder zu verkleinern.	*
			   *						*
			   * WM_ARROWED:				*
			   *						*
			   * Der Benutzer hat einen der vier Pfeile	*
			   * oder eines der beiden Scrollfelder ange-	*
			   * klickt, um eine Bewegung um eine Zeile	*
			   * (bzw. Spalte) oder um eine Seite durchzu-	*
			   * fhren.					*
			   *  Wort 0 = 24				*
			   *  Wort 3 = Window Handle			*
			   *  Wort 4 = Feld des Randbereichs, das ange- *
			   *	       klickt wurde:			*
			   *		0 = Seite nach oben		*
			   *		1 = Seite nach unten		*
			   *		2 = Zeile nach oben		*
			   *		3 = Zeile nach unten		*
			   *		4 = Seite nach links		*
			   *		5 = Seite nach rechts		*
			   *		6 = Spalte nach links		*
			   *		7 = Spalte nach rechts		*
			   *						*
			   * WM_HSLID:					*
			   *						*
			   * Der Benutzer hat den horizontalen Schieber *
			   * auf eine neue Position geschoben.		*
			   *  Wort 0 = 25				*
			   *  Wort 3 = Window Handle			*
			   *  Wort 4 = relative Position des Schiebers	*
			   *	       von 0-1000.			*
			   *		0 = Position ganz links 	*
			   *		1000 = Position ganz rechts	*
			   *						*
			   * WM_VSLID:					*
			   *						*
			   * Der Benutzer hat den vertikalen Schieber	*
			   * auf eine neue Position geschoben.		*
			   *  Wort 0 = 26				*
			   *  Wort 3 = Window Handle			*
			   *  Wort 4 = relative Position des Schiebers	*
			   *	       von 0-1000			*
			   *		0 = Position ganz oben		*
			   *		1000 = Position ganz unten	*
			   *						*
			   * WM_SIZED:					*
			   *						*
			   * Der Benutzer hat das Grenfeld (engl.	*
			   * size box) mit der Maus angewhlt und	*
			   * mchte die Gre des Fensters ndern. Die	*
			   * neue Gre wird einschlielich Randelemen- *
			   * te angegeben.				*
			   *  Wort 0 = 27				*
			   *  Wort 3 = Window Handle			*
			   *  Wort 4 = gewnschte X-Koordinate des Fen- *
			   *	       sters (stimmt mit der momentanen *
			   *	       X-Koordinate berein)		*
			   *  Wort 5 = gewnschte Y-Koordinate des Fen- *
			   *	       sters (stimmt mit der momentanen *
			   *	       Y-Koordinate berein)		*
			   *  Wort 6 = gewnschte (neue) Breite des	*
			   *	       Fensters 			*
			   *  Wort 7 = gewnschte (neue) Hhe des	*
			   *	       Fensters 			*
			   *						*
			   * WM_MOVED:					*
			   *						*
			   * Der Benutzer hat das Positionsfeld mit der *
			   * Maus angewhlt und mchte die Position des *
			   * Fensters ndern. Die neue Position wird	*
			   * einschlielich Randelemente angegeben.	*
			   *  Wort 0 = 28				*
			   *  Wort 3 = Window Handle			*
			   *  Wort 4 = gewnschte (neue) X-Koordinate	*
			   *	       des Fensters			*
			   *  Wort 5 = gewnschte (neue) Y-Koordinate	*
			   *  Wort 6 = gewnschte Breite des Fensters	*
			   *	       (stimmt mit der momentanen	*
			   *	       Breite berein)			*
			   *  Wort 7 = gewnschte Hhe des Fensters	*
			   *	       (stimmt mit der momentanen	*
			   *	       Hhe berein)			*
			   *						*
			   * WM_NEWTOP: 				*
			   *						*
			   * Der Applikation wird mitgeteilt, da ein	*
			   * Fenster aktiviert wurde.			*
			   *  Wort 0 = 30				*
			   *  Wort 3 = Window Handle			*
			   *						*
			   * AC_OPEN:					*
			   *						*
			   * Der Benutzer hat eines der sechs mglichen *
			   * Schreibtischzubehre ausgewhlt.		*
			   *  Wort 0 = 30				*
			   *  Wort 3 = die Menidentifikationsnummer,	*
			   *	       die durch die Funktion		*
			   *	       MENU_REGISTER..\MENU\MENU_REG.C erfragt werden kann*
			   *						*
			   * AC_CLOSE:					*
			   *						*
			   * Dieses Ereignis tritt bei folgenden Bedin- *
			   * gungen ein:				*
			   * - Der Bildschirm wird gelscht.		*
			   * - Die Fensterdaten haben sich gendert.	*
			   * - Die laufende Applikation ist abgebrochen *
			   *   worden.					*
			   *  Wort 0 = 31				*
			   *  Wort 3 = Menidentifikationsnummer	*
			   *	       (siehe auch AC_OPEN)		*/
  AES( 23, 0, 1, 1, 0 );

  return intout[0]; /* reserviert fr zuknftige Anwendungen. Der Wert	*
		     * wird immer auf 1 gesetzt.			*/
}
/* siehe auch: EVNT_MULTIEVNT_MUL.C */
