/*
 *  V_JUSTIFIED 				(C) Digital Design 1991
 *
 *  Diese Funktion erlaubt die Ausgabe komfortabel formatierter Texte
 *  auf den Bildschirm. Der Text wird links und rechts justiert, indem
 *  die linke Ausrichtung sowie die Textlnge wahlfrei bestimmt wird.
 *  Der Text wird durch Einfgen von Zwischenrumen innerhalb der
 *  Zeichen oder der Worte auf die gewnschte Lnge gedehnt.
 *  Die Ausdehnung der Zeichen und/oder der Worte kann ein- und
 *  ausgeschaltet werden.
 */
#include <gemdefs.h>

void v_justified( int handle, int x, int y, char *string,
		  int length, int word_space, int char_space )
{
  int  *pintin;
  char *pstring;

  ptsin[0] = x; /* x-Koordinate der Textausrichtung		*/
  ptsin[1] = y; /* y-Koordinate der Textausrichtung		*/
  ptsin[2] = length; /* gewnschte Textlnge in x-Richtung	*/
  ptsin[3] = 0;
  pintin = intin; pstring = string;
  *pintin++ = word_space; /* Flag fr Wort-Dehnung:		*
			   *	 0 = Wortdehnung aus		*
			   *	 1 = Wortdehnung ein		*/
  *pintin++ = char_space; /* Flag fr Zeichendehnung:		*
			   *	 0 = Zeichendehnung aus 	*
			   *	 1 = Zeichendehnung ein 	*/
  while ((*pintin++ = (unsigned char)*pstring++) != 0);

  contrl[5] = 10; VDI( 11, 2, (int)(pstring - string + 1), handle );
}
/* siehe auch: v_gtextV_GTEXT.C, vst_alignment..\ATTRIB\VST_ALIG.C */
