/*
 *  V_ELLPIE					(C) Digital Design 1991
 *
 *  Diese Funktion erzeugt einen ausgefllten Ellipsenausschnitt, dessen
 *  Anfang und Ende mit dem Mittelpunkt verbunden ist. Diese Flche
 *  bezeichnet man auch als elliptische Torte. Es werden Anfangs- und
 *  Endwinkel, X- und Y-Radius sowie der Mittelpunkt angegeben.
 *  Folgende Attribute fr Flloperationen finden Verwendung:
 *	Fllfarbe
 *	Flltyp (leer, voll, punktiert, Muster, schraffiert oder
 *		selbstdefiniert)
 *	Zeichenmodus
 *	Fllmuster
 *	Einrahmung
 */
#include <gemdefs.h>

void v_ellpie( int handle, int x, int y, int xradius, int yradius,
	       int begang, int endang )
{
  intin[0] = begang; /* Startwinkel (0-3600)			*/
  intin[1] = endang; /* Endwinkel (0-3600)			*/
  ptsin[0] = x; /* x-Koordinate des Mittelpunktes		*/
  ptsin[1] = y; /* y-Koordinate des Mittelpunktes		*/
  ptsin[2] = xradius; /* Radius in x-Richtung			*/
  ptsin[3] = yradius; /* Radius in y-Richtung			*/

  contrl[5] = 7; VDI( 11, 2, 2, handle );
}
