/*
 *  V_ALPHA_TEXT                                (C) Digital Design 1991
 *
 *  OUTPUT ALPHA TEXT
 *
 *  Mit Hilfe dieser Funktion ist es mglich, alphanumerischen Text auf
 *  einem Drucker auszugeben. Die angegebene Zeichenkette wird nicht im
 *  Grafikmodus ausgegeben, sondern im Standard-Druckerzeichensatz.
 *  Das WORDPLUS, das mit GEM/3 mitgeliefert wird, bedient sich dieser
 *  Methode, um Texte auszugeben. Es existieren keine Konfigurations-
 *  dateien mehr fr den Drucker (HEX, CFG), vielmehr erzeugt WORDPLUS
 *  eine OUT-Datei, in der alle Informationen fr den Text stehen. Bei
 *  der Ausgabe des Textes auf die OUT-Datei werden auerdem Steuerzei-
 *  chen mitgeschrieben, die die Attribute eines Textes bestimmen.
 *  Diese Steuerzeichen fr Textattribute sind von Digital Research
 *  vorgeschrieben und werden vom OUTPUT an den Drucker weitergeleitet.
 *  Es ist Aufgabe des Druckertreibers, diese zu analysieren und auf
 *  das entsprechende Textattribut umzuschalten. Alle Steuerzeichen
 *  werden mit dem ASCII Code DC2 (Dezimalwert 18) eingeleitet.
 *  Folgende Steuerzeichen sind definiert und schalten ein Attribut
 *  ein oder aus:
 *
 *      (DC2) '0' = Fettschrift ein     (DC2) '1' = Fettschrift aus
 *      (DC2) '2' = Kursivschrift ein   (DC2) '3' = Kursivschrift aus
 *      (DC2) '4' = Unterstreichen ein  (DC2) '5' = Unterstreichen aus
 *      (DC2) '6' = Superscript ein     (DC2) '7' = Superscript aus
 *      (DC2) '8' = Subscript ein       (DC2) '9' = Subscript aus
 *      (DC2) 'A' = NLQ-Schrift ein     (DC2) 'B' = NLQ-Schrift aus
 *      (DC2) 'C' = Breitschrift ein    (DC2) 'D' = Breitschrift aus
 *      (DC2) 'E' = Hellschrift ein     (DC2) 'F' = Hellschrift aus
 *      (DC2) 'G' - (DC2) 'V' = reserviert
 *      (DC2) 'W' = Pica ein
 *      (DC2) 'X' = Elite ein
 *      (DC2) 'Y' = Schmalschrift ein
 *      (DC2) 'Z' = Proportionalschrift ein
 */
#include <gemdefs.h>

void v_alpha_text( int handle, char *string )
{
  int  *pintin;
  char *pstring;

  pintin = intin; pstring = string;
  while ((*pintin++ = (unsigned char)*pstring++) != 0);
  contrl[5] = 25;

  VDI( 5, 0, (int)(pstring - string - 1), handle );
}
