/*
 *  VQ_SCAN                                     (C) Digital Design 1991
 *
 *  INQUIRE PRINTER SCAN
 *
 *  Diese Funktion fragt verschiedene druckerspezifische Parameter ab.
 *  Der Druckertreiber unterteilt eine Druckseite in mehrere "Scheiben"
 *  (slices), die nacheinander formatiert und gedruckt werden, um den
 *  Speicherplatzbedarf zu senken. Dabei ist g_slice die Anzahl dieser
 *  Scheiben und g_page die Pixelhhe einer Scheibe. a_slice gibt die
 *  Hhe einer Textzeile in Pixel und a_page die Anzahl Textzeilen pro
 *  Seite an.
 *  Durch div_fac mssen die anderen Werte ggf. noch geteilt werden.
 */
#include <gemdefs.h>

void vq_scan( int handle, int *g_slice, int *g_page,
              int *a_slice, int *a_page, int *div_fac )
{
  contrl[5] = 24;

  VDI( 5, 0, 0, handle );

  *g_slice = intout[0]; /* Anzahl der Drucker-Scheiben          */
  *g_page  = intout[1]; /* Pixelhhe einer Scheibe              */
  *a_slice = intout[2]; /* Hhe einer Textzeile in Pixel        */
  *a_page  = intout[3]; /* Textzeilen pro Seite                 */
  *div_fac = intout[4]; /* Divisor                              */
}
