/*
 *  VQ_EXTND					(C) Digital Design 1991
 *
 *  EXTENDED INQUIRE FUNCTION
 *
 *  Diese erweiterte Nachfragefunktion bietet zwei Mglichkeiten:
 *  - Die nachtrgliche Ermittlung der 57 OPEN WORKSTATION..\CONTROL\V_OPNWK.C-Parameter,
 *  - Die Ermittlung 19 weiterer gertespezifischer Informationen.
 *  Unabhngig vom Informationstyp werden auf jeden Fall 45 intout-
 *  und 6 ptsout- bzw. 57 work_out-Parameter zurckgegeben.
 */
#include <gemdefs.h>

void vq_extnd( int handle, int owflag, int *work_out )
{
  intin[0] = owflag; /* Informationstyp:				*
		      * 	0 = OPEN WORKSTATION..\CONTROL\V_OPNWK.C-Parameter          *
		      * 	1 = erweiterte Parameter		*/
  vdipb[3] = work_out;
  vdipb[4] = work_out + 45;

  VDI( 102, 0, 1, handle );

  vdipb[3] = intout;
  vdipb[4] = ptsout;

  /* Die erweiterten Parameter (Angabe der work_out-Nummer):		*
   * 0: Art des Bildschirms:						*
   *	0 = kein Bildschirm						*
   *	1 = separater Alpha- und Grafikcontroller mit separatem 	*
   *	    Bildschirm							*
   *	2 = separater Alpha- und Grafikcontroller mit gemeinsamem	*
   *	    Bildschirm							*
   *	3 = gemeinsamer Alpha- und Grafikcontroller mit separatem	*
   *	    Grafikspeicher						*
   *	4 = gemeinsamer Alpha- und Grafikcontroller mit gemeinsamem	*
   *	    Grafikspeicher						*
   * 1: Anzahl der verfgbaren Hintergrundfarben			*
   * 2: untersttzte Texteffekte					*
   * 3: Vergrerungsraster:						*
   *	0 = Vergrerung nicht mglich					*
   *	1 = Vergrerung mglich					*
   * 4: Anzahl der Farbebenen fr Raster				*
   * 5: "look-up table"-Untersttzung:					*
   *	0 = wird untersttzt						*
   *	1 = wird nicht untersttzt					*
   * 6: Anzahl der 16 * 16-Raster-Operationen je Sekunde		*
   * 7: CONTOUR FILL..\OUTPUT\V_CONTOU.C-Untersttzung:				        *
   *	0 = wird nicht untersttzt					*
   *	1 = wird untersttzt						*
   * 8: Untersttzung Text-Rotation:					*
   *	0 = keine Untersttzung 					*
   *	1 = nur in 90-Grad-Schritten					*
   *	2 = beliebige Rotationswinkel					*
   * 9: Anzahl der Zeichen-Modi 					*
   * 10: hchstmglicher Eingabe-Modus: 				*
   *	 0 = keiner							*
   *	 1 = request-Modus						*
   *	 2 = sample-Modus						*
   * 11: Untersttzung Textausrichtung: 				*
   *	 0 = wird nicht untersttzt					*
   *	 1 = wird untersttzt						*
   * 12: Farbwechsel mit Farbstiften (Plotter): 			*
   *	 0 = wird beherrscht						*
   *	 1 = wird nicht beherrscht					*
   * 13: Farbwechsel mit Farbbandverschiebung (Matrixdrucker):		*
   *	 0 = wird beherrscht						*
   *	 1 = wird nicht beherrscht					*
   * 14: maximale Anzahl der Punkte in polyline, polymarker oder	*
   *	 filled area (-1 = unbegrenzt)					*
   * 15: maximale Lnge intin-Array (-1 = unbegrenzt)			*
   * 16: Anzahl der Maustasten						*
   * 17: Linientypen fr verbreiterte Linien:				*
   *	 0 = wird nicht untersttzt					*
   *	 1 = wird untersttzt						*
   * 18: Zeichenmodi fr verbreiterte Linien				*
   * 19-56: reserviert, enthlt Wert 0					*/
}
