/*
 *  VQT_FONTINFO				(C) Digital Design 1992
 *
 *  INQUIRE CURRENT FACE INFORMATION
 *
 *  Diese Funktion gibt ber den aktuellen Zeichensatz Auskunft.
 *  Es wird die gegenwrtige Gre ausgegeben. Die aktuellen Text-
 *  effekte werden ebenso bercksichtigt. Sollten die Zeichen in
 *  Kursivschrift dargestellt sein, so wird die Neigung als rechter
 *  und linker Offsetwert bedacht. Rechter Offsetwert ist der hori-
 *  zontale Abstand der Zeichenposition (linkes Basislinienende)
 *  zum Lotfupunkt des Lotes auf die Basislinie durch die obere
 *  rechte Ecke. Linker Offset ist der Abstand der Zeichenposition
 *  zum Lotfupunkt des Lotes auf die Basislinie durch die untere
 *  linke Ecke.
 */
#include <gemdefs.h>

void vqt_fontinfo( int handle, int *minADE, int *maxADE,
		   int *distances, int *maxwidth, int *effects )
{
  VDI( 131, 0, 0, handle );

  *minADE = intout[0]; /* niedrigster ASCII-Wert,		*
			* erstes Zeichen des Zeichensatzes	*/
  *maxADE = intout[1]; /* hchster ASCII-Wert,			*
			* letztes Zeichen des Zeichensatzes	*/
  *maxwidth = ptsout[0]; /* maximale Zeichenzellenbreite	*
			  * ohne Texteffekte			*/
  distances[0] = ptsout[1]; /* Abstand Untergrenze Zeichenzelle *
			     * zur Basislinie (bzgl. Y-Achse)	*/
  distances[1] = ptsout[3]; /* Abstand Untergrenze Zeichen	*
			     * (Unterlngen) zur Basislinie	*
			     * (bzgl. Y-Achse)			*/
  distances[2] = ptsout[5]; /* Abstand Halblinie (Obergrenze	*
			     * Kleinbuchstaben (wie a,c,e,g))	*
			     * zur Basislinie (bzgl. Y-Achse)	*/
  distances[3] = ptsout[7]; /* Abstand Obergrenze Zeichen	*
			     * zur Basislinie (bzgl. Y-Achse)	*/
  distances[4] = ptsout[9]; /* Abstand Obergrenze Zeichenzelle	*
			     * zur Basislinie (bzgl. Y-Achse)	*/
  effects[0] = ptsout[2]; /* Betrag, um den die Zeichenbreite	*
			   * bei den aktuell eingestellten Text-*
			   * effekten zunimmt (bzgl. X-Achse)	*/
  effects[1] = ptsout[4]; /* linker Offsetwert (bzgl. X-Achse)	*/
  effects[2] = ptsout[6]; /* rechter Offsetwert (bzgl. X-Achse) */
}
