/*
 *  VQIN_MODE                                   (C) Digital Design 1990
 *
 *  INQUIRE INPUT MODE
 *
 *  Diese Funktion ermittelt den aktuellen Eingabemodus einer spezifi-
 *  zierten logischen Eingabeeinheit.
 */
#include <gemdefs.h>

void vqin_mode( int handle, int dev_type, int *input_mode )
{
  intin[0] = dev_type; /* logische Eingabeeinheit:                      *
                        *       1 = Grafikcursor-Einheit                *
                        *       2 = wertverndernde Eingabeeinheit      *
                        *       3 = Auswahl-Eingabeeinheit              *
                        *       4 = String-Eingabeeinheit               */
  VDI( 115, 0, 1, handle );

  *input_mode = intout[0]; /* Eingabe-Modus:                            *
                            *   0 = request-Modus                       *
                            *   1 = sample-Modus                        */
}
/* siehe auch: vsin_mode..\INPUT\VSIN_MOD.C */

