/*
 *  V_SHOW_C                                    (C) Digital Design 1990
 *
 *  SHOW CURSOR
 *
 *  Diese Funktion bewirkt, da der Grafikcursor auf dem Bildschirm
 *  sichtbar wird und mit der Maus bewegt werden kann. Der Cursor kann
 *  mit der Funktion V_HIDE_CV_HIDE_C.C wieder ausgeschaltet werden.
 *  Das VDI notiert intern, wie oft die Funktion V_HIDE_CV_HIDE_C.C aufgerufen
 *  wurde. Zur Darstellung des Cursors ist dann die gleiche Anzahl
 *  Aufrufe von V_SHOW_C notwendig. Diese Beziehung zwischen den beiden
 *  Funktion kann jedoch auch ausgeschaltet werden.
 */
#include <gemdefs.h>

void v_show_c( int handle, int reset )
{
  intin[0] = reset; /* 0 = Anzahl der V_HIDE_CV_HIDE_C.C-Aufrufe wird ignoriert   *
                     * 1 = normale Funktion                             */
  VDI( 122, 0, 1, handle );
}

