/*
 *  VSM_STRING                                  (C) Digital Design 1990
 *
 *  INPUT STRING, SAMPLE MODE
 *
 *  Diese Funktion entspricht weitgehend dem request-Modus. Es wird zu-
 *  stzlich die Information zurckgegeben, ob eine ungltige Taste ge-
 *  drckt wurde. Dies kann im request-Modus nicht ermittelt werden.
 *  Wenn der String grundstzlich mit RETURN beendet wird, sollte die
 *  Funktion deshalb im request-Modus ausgefhrt werden.
 *  Wenn die maximale Stringlnge negativ ist, so wird im intout-Array
 *  der 2-Byte-Code der VDI-Standard-Tastatur angelegt.
 */
#include <gemdefs.h>

int vsm_string( int handle, int max_length, int echo_mode,
                int echo_xy[2], char *string )
{
  intin[0] = max_length; /* maximale Stringlnge                        */
  intin[1] = echo_mode; /* Echo-Modus:  0 = Echo-Modus ausgeschaltet    *
                         *              1 = Echo-Modus eingeschaltet    */
  ptsin[0] = echo_xy[0]; /* x-Koordinate des Echo-Bereiches             */
  ptsin[1] = echo_xy[1]; /* y-Koordinate des Echo-Bereiches             */

  VDI( 31, 1, 2, handle );

  string[max_length] = 0; /* eingegebener String                        */
  while (max_length-- > 0) string[max_length] = intout[max_length];
  return contrl[4]; /* = status:  0 = Funktion wurde mit ungltigem     *
                     *                Zeichen abgebrochen               *
                     *           >1 = Gre des Strings                 */
}
/* siehe auch: vrq_stringVRQ_STRI.C, vsin_modeVSIN_MOD.C */

