/*
 *  VSM_LOCATOR                                 (C) Digital Design 1990
 *
 *  INPUT LOCATOR, SAMPLE MODE
 *
 *  Der Grafikcursor wird von einem Interrupt gesteuert. Das heit, das
 *  Programm mu die Bewegung des Cursors nicht koordinieren. Der Anwen-
 *  der kann den Cursor bewegen, auch wenn das Programm gerade mit
 *  Anderem beschftigt ist. Diese Funktion nun ermglicht jederzeit
 *  festzustellen, was sich in der Zwischenzeit getan hat. Der Funktion
 *  wird eine initialisierende Koordinate bergeben. Die Funktion gibt
 *  dann zurck, ob die Koordinaten, also die Position des Grafikcursors,
 *  gendert wurde und ob eine Taste bettigt wurde. Die entsprechende
 *  genderte Position und die bettigte Taste werden selbstverstndlich
 *  auch bermittelt.
 */
#include <gemdefs.h>

int vsm_locator( int handle, int x, int y, int *xout, int *yout, int *term )
{
  ptsin[0] = x; /* initialisierende Position des Grafikcursors          *
                 * (x-Koordinate)                                       */
  ptsin[1] = y; /* initialisierende Position des Grafikcursors          *
                 * (y-Koordinate)                                       */
  VDI( 28, 1, 0, handle );

  *term = intout[0]; /* Funktions-Ende-Taste:                           *
                      * Im Low-Byte dieses Parameters wird der ASCII-   *
                      * Code der Taste eingetragen, die bettigt wurde  *
                      * (z.B. RETURN = 13). Spezielle Ende-Tasten sind  *
                      * z.B. die beiden Maus-Knpfe oder Tasten eines   *
                      * Grafiktabletts. Der Code dieser Tasten beginnt  *
                      * ab 20h (32). Die linke Taste der Maus hat den   *
                      * Code 20h (32), die rechte 21h (33).             */
  *xout = ptsout[0]; /* neue x-Position                                 */
  *yout = ptsout[1]; /* neue y-Position                                 */
  return (contrl[2] | (contrl[4] << 1)); /* = status:                   *
   * contrl[2]:  1 = Koordinaten sind gendert worden                   *
   *             0 = Koordinaten sind nicht gendert worden             *
   * contrl[4]:  1 = Taste wurde bettigt                               *
   *             0 = keine Taste wurde bettigt                         */
}
/* siehe auch: vrq_locatorVRQ_LOCA.C, vsin_modeVSIN_MOD.C */

