/*
 *  VEX_TIMV					(C) Digital Design 1990
 *
 *  EXCHANGE TIMER INTERRUPT VECTOR
 *
 *  Mit dieser Funktion kann der Interrupt des Systems auf eine eigene
 *  Routine gelegt werden. Der Funktion wird die Adresse der eigenen
 *  Interruptroutine im 32-Bit-Format bergeben Die Funktion gibt dann
 *  die alte Interruptadresse und den Intervall des Interruptaufrufs
 *  in Millisekunden zurck.
 *  Die eigene Interruptroutine mu selbst fr die Sicherstellung der
 *  Register und den Rcksprung zum System sorgen. Der Systeminterrupt
 *  wird wieder aktiviert, indem wieder die alte Interruptadresse
 *  gesetzt wird.
 */
#include <gemdefs.h>

void vex_timv( int handle, int (*tim_addr)(), int (**otim_addr)(),
	       int *tim_conv )
{
  *(int (**)())(contrl + 7) = tim_addr; 	/* Adresse der neuen	*
						 * Interrupt-Routine	*/
  VDI( 118, 0, 0, handle );

  *otim_addr = *(int (**)())(contrl + 9);	/* Adresse der alten	*
						 * Interrupt-Routine	*/
  *tim_conv = intout[0];	/* Interrupt-Intervall in Millisekunden */
}