/*
 *  V_BIT_IMAGE                                 (C) Digital Design 1991
 *
 *  OUTPUT BIT IMAGE FILE
 *
 *  Die Funktion "OUTPUT BIT IMAGE FILE" kann nur in Verbindung mit
 *  einem Drucker benutzt werden. Mit "OUTPUT BIT IMAGE FILE" kann
 *  die in einem entsprechenden File abgespeicherte Bild-Information
 *  gelesen und auf dem Drucker ausgegeben werden.
 */
#include <gemdefs.h>

void v_bit_image( int handle, char *filename, int aspect, int x_scale,
                  int y_scale, int h_align, int v_align, int *xyarray )
{
  int  *pintin;
  char *pstring;

  vdipb[2] = xyarray;  /* xyarray[0] = x-Koordinate der oberen linken   *
                        *              Ecke des Ausgaberechtecks        *
                        * xyarray[1] = y-Koordinate der oberen linken   *
                        *              Ecke des Ausgaberechtecks        *
                        * xyarray[2] = x-Koordinate der unteren rechten *
                        *              Ecke des Ausgaberechtecks        *
                        * xyarray[3] = y-Koordinate der unteren rechten *
                        *              Ecke des Ausgaberechtecks        */
  pintin = intin;
  *pintin++ = aspect;  /* Aspect Ratio (Abbildungsmastab)              *
                        *  0 = Aspect Ratio wird ignoriert              *
                        *  1 = Pixel werden bercksichtigt (z.B. Kreise *
                        *      werden wieder auf Kreise abgebildet)     */
  *pintin++ = x_scale; /* Skalierung der X-Achse                        *
                        *  0 = gebrochen, 1 = ganzzahlig                */
  *pintin++ = y_scale; /* Skalierung der Y-Achse                        *
                        *  0 = gebrochen, 1 = ganzzahlig                */
  *pintin++ = h_align; /* Horizontale Ausrichtung                       *
                        *  0 = links, 1 = zentriert, 2 = rechts         */
  *pintin++ = v_align; /* Vertikale Ausrichtung                         *
                        *  0 = oben, 1 = zentriert, 2 = unten           */
  pstring = filename;
  while ((*pintin++ = (unsigned char)*pstring++) != 0);
  contrl[5] = 23;

  VDI( 5, 2, (int)(pstring - filename + 4), handle );

  vdipb[2] = ptsin;
}
