/*
 *  VSWR_MODE                                   (C) Digital Design 1990
 *
 *  SET WRITING MODE
 *
 *  Die von den Grafikoperationen erzeugten Zeichnungen werden im Normal-
 *  fall ohne Rcksicht auf bisher auf dem Arbeitsbereich enthaltene
 *  Zeichnungen ausgegeben. Das heit, da Punkte immer dort gesetzt
 *  werden, wo noch keine gesetzt sind. GEM..\..\GEM bietet mehrere Mglichkeiten,
 *  beim Ausgeben der Grafik bereits vorhandene Grafik zu bercksichtigen.
 *  Nicht nur die Punkte, auch die Farbe der Punkte spielt hier eine
 *  Rolle. Fr die Beschreibung der Zeichenmodi sollen zunchst die
 *  Operatoren fr die Bool'schen Formeln beschrieben werden:
 *      obj = Grafikobjekt (Linie, Fllmuster, Kreis usw.)
 *      col = Farbmaske des Objektes
 *      old = Farbe des bereits gesetzten Punktes
 *      new = resultierende Punktfarbe
 *              Replace-Modus:
 *  Der Replace-Modus setzt die Punkte ohne Rcksicht auf die vorhandene
 *  Grafik. Diese ist der normale Zeichenmodus.
 *      new = col AND obj
 *              Transparent-Modus:
 *  Im Transparent-Modus werden die Punkte nur dort gesetzt, wo noch keine
 *  Punkte vorhanden sind. Weiterhin werden die Punkte der Grafik gelscht,
 *  an die Punkte ohne Farbe gesetzt werden sollen. Dies lt sich an einem
 *  Beispiel besser erklren: Eine ausgefllte Flche soll gezeichnet wer-
 *  den. Ist der Bildschirmbereich leer, so besteht kein Unterschied zwi-
 *  schen Replace- und Transparent-Modus. Ist der Bildschirmbereich jedoch
 *  bereits mit Grafik belegt, so wrde das Fllmuster im Replace-Modus
 *  nicht zu erkennen sein. Ein Fllmuster auf einem Bildschirm, der die
 *  Farbe des Fllmusters hat, ist so im Replace-Modus nicht zu erkennen.
 *      new = (col AND obj) OR (old AND NOT obj)
 *              XOR-Modus:
 *  Im XOR-Modus werden nur dort Punkte gesetzt, wo in der vorhandenen
 *  Grafik keine enthalten sind. Alle bereits gesetzten Punkte an den neuen
 *  Positionen werden gelscht. Die Schnittpunkte einer alten und einer
 *  neuen Linie werden demnach gelscht.
 *      new = obj XOR old
 *              REVERSE TRANSPARENT-MODUS
 *  In diesem Modus bleiben alle berschneidenden Punkte erhalten, fr die
 *  im Objekt keine Farbe zugeordnet ist (z.B. die Lcken einer gestrichel-
 *  ten Linie). Die berschneidenden Punkte, fr die im Objekt eine Farbe
 *  zugeordnet wurde, werden gelscht. Ein auf eine schwarze Flche ge-
 *  zeichnetes Fllmuster im Reverse-Transparent-Modus ist demnach das
 *  Negativ vom entsprechenden Fllmuster im Transparent-Modus.
 *      new = (old AND obj) OR (col AND NOT obj)
 */
#include <gemdefs.h>

int vswr_mode( int handle, int mode )
{
  intin[0] = mode; /* Zeichenmodus:  1 = Replace                        *
                    *                2 = Transparent                    *
                    *                3 = XOR                            *
                    *                4 = Reverse Transparent            */
  VDI( 32, 0, 1, handle );

  return intout[0]; /* = set_mode: Ausgewhlter Zeichenmodus            */
}

