/*
 *  VST_POINT                                   (C) Digital Design 1990
 *
 *  SET CHARACTER CELL HEIGHT, POINTS MODE
 *
 *  Jedes Zeichen befindet sich innerhalb einer Box, deren Hhe mit dieser
 *  Funktion eingestellt wird. Die Hhe der Box wird in Druckerschritten
 *  von 1/72 inch angegeben. Die Hhe der Zeichenbox entspricht dem
 *  Abstand zwischen den Grundlinien der Druckzeilen.
 *  Die Funktion gibt die aktuelle Hhe und Breite der Zeichen und
 *  Zeichenbox in NDC/RC-Koordinaten zurck. Bei Proportionalschrift
 *  werden die Mae des grten Zeichens ausgegeben.
 */
#include <gemdefs.h>

int vst_point( int handle, int point, int *char_width, int *char_height,
               int *cell_width, int *cell_height )
{
  intin[0] = point; /* Hhe der Zeichenbox (Zeilenabstand)              */

  VDI( 107, 0, 1, handle );

  *char_width = ptsout[0];  /* Aktuelle Zeichenbreite                   */
  *char_height = ptsout[1]; /* Aktuelle Zeichenhhe                     */
  *cell_width = ptsout[2];  /* Aktuelle Zeichenbox-Breite               */
  *cell_height = ptsout[3]; /* Aktuelle Zeichenbox-Hhe                 */
  return intout[0]; /* = set_point: Ausgewhlte Hhe der Box            */
}
/* siehe auch: vst_heightVST_HEIG.C */

