/*
 *  VST_ALIGNMENT				(C) Digital Design 1991
 *
 *  SET GRAPHIC TEXT ALIGNMENT
 *
 *  Der Text, der mit V_GTEXT..\OUTPUT\V_GTEXT.C sowie V_JUSTIFIED..\OUTPUT\V_JUSTIF.C ausgegeben wird, kann
 *  mit dieser Funktion horizontal und vertikal ausgerichtet werden.
 */
#include <gemdefs.h>

void vst_alignment( int handle, int hor_in, int vert_in,
		    int *hor_out, int *vert_out )
{
  intin[0] = hor_in; /* horizontale Ausrichtung:			*
		      *      0 = linksbndig				*
		      *      1 = zentriert				*
		      *      2 = rechtsbndig				*/
  intin[1] = vert_in; /* vertikale Ausrichtung: 			*
		       *     0 = baseline (Untergrenze Zeichenbox)	*
		       *     1 = half line (Obergrenze Kleinbuchstaben) *
		       *     2 = ascent line (Obergrenze Zeichen)	*
		       *     3 = bottom line (Untergrenze Zeichenbox)	*
		       *     4 = descent line (Untergrenze Unterlngen) *
		       *     5 = top line (Obergrenze Zeichenbox)	*/
  VDI( 39, 0, 2, handle );

  *hor_out = intout[0];  /* Ausgewhlte horizontale Ausrichtung 	*/
  *vert_out = intout[1]; /* Ausgewhlte vertikale Ausrichtung		*/
}
