/*
 *  VSL_TYPE                                    (C) Digital Design 1990
 *
 *  SET POLYLINE LINE TYPE
 *
 *  Mit der Funktion V_PLINE..\OUTPUT\V_PLINE.C knnen nicht nur durchgezogene Linien
 *  gezeichnet werden, sondern auch gestrichelte. Der gewnschte Linien-
 *  typ kann mit dieser Funktion aus mehreren zur Verfgung stehenden
 *  ausgewhlt werden.
 *  Diese Funktion ist nicht auf jedem Gert verfgbar. Die Funktionen
 *  V_OPNWK..\CONTROL\V_OPNWK.C und V_OPNVWK..\CONTROL\V_OPNVWK.C teilen dies in work_out[6] mit.
 */
#include <gemdefs.h>

int vsl_type( int handle, int style )
{
  intin[0] = style; /* Linientyp:     style     MSB (16 Bit) LSB        *
                     *                  1       1111111111111111        *
                     *                  2       1111111111110000        *
                     *                  3       1110000011100000        *
                     *                  4       1111111000111000        *
                     *                  5       1111111100000000        *
                     *                  6       1111000110011000        *
                     *                  7       extern definiert        *
                     * Der Typ 7 mu mit der Funktion VSL_UDSTY         *
                     * definiert werden.                                */
  VDI( 15, 0, 1, handle );

  return intout[0]; /* = set_type: Ausgewhlter Linientyp               */
}

