/*
 *  VSF_UPDAT                                   (C) Digital Design 1990
 *
 *  SET USER DEFINED FILL PATTERN
 *
 *  Bei der Funktion VSF_INTERIORVSF_INTE.C zur Bestimmung des Flltyps kann auch
 *  ein benutzerdefinierter Flltyp angegeben werden. Dieses Fllmuster
 *  wird hier eingerichtet.
 *  Das Fllmuster erstreckt sich ber 16 2-Byte-Worte. Das Bit 15 des
 *  ersten Wortes ist der obere rechte und das Bit 1 des 16. Wortes der
 *  untere rechte Punkt des Fllmusters.
 *  Mehrfarbige Fllmuster erstrecken sich ber mehrere 16-Wort-Gruppen,
 *  die hintereinander im Eingabe-Array enthalten sind. Fr jede Farbe
 *  mu eine Gruppe definiert werden.
 */
#include <gemdefs.h>

void vsf_updat( int handle, int *pfill_pat, int planes )
{
  vdipb[1] = pfill_pat; /* Fllmuster-Definitions-Array                 */

  VDI( 112, 0, planes <<= 4, handle ); /* planes=Anzahl der Fllfarben  */

  vdipb[1] = intin;
}

