/*
 *  VSF_STYLE                                   (C) Digital Design 1990
 *
 *  SET FILL STYLE INDEX
 *
 *  Diese Funktion erweitert die Mglichkeiten zum Ausfllen von Flchen.
 *  Sie erlaubt die Auswahl von 24 verschiedenen Punktmustern und 12 ver-
 *  schiedenen Schraffiermustern. Vor Aufruf dieser Funktion mu der
 *  Flltyp PUNKTIERT oder SCHRAFFIERT mit der Funktion VSF_INTERIORVSF_INTE.C ein-
 *  gestellt werden.
 *  Wird zuvor ein anderer Flltyp als 2 (PUNKTIERT) oder 3 (SCHRAFFIERT)
 *  ausgewhlt, so hat diese Funktion keine Auswirkung auf das Fllmuster.
 *  Ist die Nummer des Flltyps ungltig, so wird der Standard-Flltyp
 *  gesetzt.
 */
#include <gemdefs.h>

int vsf_style( int handle, int style_index )
{
  intin[0] = style_index; /* Fllmuster (1-24 bzw. 1-12)                */

  VDI( 24, 0, 1, handle );

  return intout[0]; /* = set_style: Ausgewhltes Fllmuster             */
}

