/*
 *  WIND_GET					(C) Digital Design 1990
 *
 *  Erfragen von Fensterparametern.
 *  Fr jedes Fenster knnen die Elemente der Rechteckliste, die Gre
 *  des Fensters sowie die Gre und Position des horizontalen und
 *  vertikalen Schiebers erfragt werden.
 */
#include <gemdefs.h>
#include <stdarg.h>

typedef int *INTP;

int wind_get( int wi_ghandle, int wi_gfield, ...
	      /* int *wi_gw1, int *wi_gw2, int *wi_gw3, int *wi_gw4 */ )
{
  va_list ap;

  intin[0] = wi_ghandle; /* Window Handle des Fensters, dessen		*
			  * Parameter erfragt werden sollen.		*/
  intin[1] = wi_gfield; /* gibt an, welche Informationen erfragt werden *
			 * sollen:					*
			 *						*
			 * 4: Die Koordinaten des Arbeitsbereichs eines *
			 * Fensters werden ausgegeben:			*
			 *     *wi_gw1 = X-Koordinate			*
			 *     *wi_gw2 = Y-Koordinate			*
			 *     *wi_gw3 = Breite 			*
			 *     *wi_gw4 = Hhe				*
			 *						*
			 * 5: Die Koordinaten der Gesamtgre des	*
			 * Fensters einschlielich Rnder, Titelzeile	*
			 * und Informationszeile werden ausgegeben:	*
			 *     *wi_gw1 = X-Koordinate			*
			 *     *wi_gw2 = Y-Koordinate			*
			 *     *wi_gw3 = Breite 			*
			 *     *wi_gw4 = Hhe				*
			 *						*
			 * 6: Die Koordinaten der Gesamtgre des vor-	*
			 * hergehenden Fensters werden ausgegeben:	*
			 *     *wi_gw1 = X-Koordinate			*
			 *     *wi_gw2 = Y-Koordinate			*
			 *     *wi_gw3 = Breite 			*
			 *     *wi_gw4 = Hhe				*
			 *						*
			 * 7: Die Koordinaten der Gesamtgre des	*
			 * Fensters in seiner grtmglichen Gre	*
			 * (durch WIND_CREATEWIND_CRE.C festgelegt) werden        *
			 * ausgegeben:					*
			 *     *wi_gw1 = X-Koordinate			*
			 *     *wi_gw2 = Y-Koordinate			*
			 *     *wi_gw3 = Breite 			*
			 *     *wi_gw4 = Hhe				*
			 *						*
			 * 8: Die relative Position des horizontalen	*
			 * Schiebers wird ausgegeben (zwischen 1 und	*
			 * 1000):					*
			 *     *wi_gw1: 1 = Position ganz links 	*
			 *		1000 = Position ganz rechts	*
			 *						*
			 * 9: Die relative Position des vertikalen	*
			 * Schiebers wird ausgegeben (zwischen 1 und	*
			 * 1000):					*
			 *     *wi_gw1: 1 = Position ganz oben		*
			 *		1000 = Position ganz unten	*
			 *						*
			 * 10: Das Window Handle des obersten		*
			 * (= aktiven) Fensters wird ausgegeben:	*
			 *     *wi_gw1 = Window Handle			*
			 *						*
			 * 11: Die Koordinaten des ersten Rechtecks in	*
			 * der Rechteckliste des Fensters werden ausge- *
			 * geben:					*
			 *     *wi_gw1 = X-Koordinate			*
			 *     *wi_gw2 = Y-Koordinate			*
			 *     *wi_gw3 = Breite 			*
			 *     *wi_gw4 = Hhe				*
			 *						*
			 * 12: Die Koordinaten des nchsten Rechtecks	*
			 * in der Rechteckliste des Fensters werden	*
			 * ausgegeben:					*
			 *     *wi_gw1 = X-Koordinate			*
			 *     *wi_gw2 = Y-Koordinate			*
			 *     *wi_gw3 = Breite 			*
			 *     *wi_gw4 = Hhe				*
			 *						*
			 * 13: Reserviert, keine Bedeutung.		*
			 *						*
			 * 15: Die Gre des horizontalen Schiebers	*
			 * relativ zur Gre des umrandenden Kastens	*
			 * wird ausgegeben:				*
			 *    *wi_gw1: -1 = Minimalgre		*
			 *		    (quadratischer Kasten)	*
			 *	       1-1000 = relative Gre im Ver-	*
			 *			gleich zum Scrollbalken *
			 *						*
			 * 16: Die Gre des vertikalen Schiebers	*
			 * relativ zur Gre des umrandenden Kastens	*
			 * wird ausgegeben:				*
			 *    *wi_gw1: -1 = Minimalgre		*
			 *		    (quadratischer Kasten)	*
			 *	       1-1000 = relative Gre im Ver-	*
			 *			gleich zum Scrollbalken *
			 *						*
			 * 17: Adresse und Lnge des internen Buffers	*
			 * fr Drop-Down-Mens und Alertboxen werden	*
			 * ausgegeben:					*
			 *     *wi_gw1 = 'Erster Teil' der Adresse	*
			 *     *wi_gw2 = 'Zweiter Teil' der Adresse	*
			 *     *wi_gw3 = 'Erster Teil' der Lnge	*
			 *     *wi_gw4 = 'Zweiter Teil' der Lnge	*/
  AES( 104, 2, 5, 0, 0 );

  va_start( ap, wi_gfield );
  *(va_arg( ap, INTP )) = intout[1];
  switch (wi_gfield)
  {
    case 4: case 5: case 6: case 7: case 11: case 12: case 17:
      *(va_arg( ap, INTP )) = intout[2];
      *(va_arg( ap, INTP )) = intout[3];
      *(va_arg( ap, INTP )) = intout[4];
  }
  va_end( ap );
  return intout[0]; /* = wi_greturn: positiv bei Erfolg, 0 bei Fehler	*
		     * (z.B. nicht existierendes Window Handle) 	*/
}
/* siehe auch: wind_setWIND_SET.C */