/*
 *  GRAF_MOUSE                                  (C) Digital Design 1990
 *
 *  Die Form des Mauszeigers kann gendert werden. Es stehen verschiedene
 *  Symbole zur Auswahl, falls diese nicht ausreichend sind, kann der
 *  Programmierer eigene Formen definieren (Bit-Belegung siehe VDI-
 *  Funktion SET MOUSE FORM..\..\VDI\INPUT\VSC_FORM.C).
 *  Die Mausform sollte nur innerhalb der vom Programm kontrollierten
 *  Bereiche von der Pfeilform abweichen. Sobald der Mauszeiger einen
 *  solchen Bereich verlt (z.B. durch Betreten der Menleiste), mu
 *  wieder die Pfeilform aktiviert werden.
 */
#include <gemdefs.h>

int graf_mouse( int gr_monumber, MFORM *gr_mofaddr )
{
  intin[0] = gr_monumber; /* gibt an, welche Mausform gewnscht wird:   *
                           *    0 = Pfeil                               *
                           *    1 = Cursor                              *
                           *    2 = Biene                               *
                           *    3 = Hand mit Zeigefinger                *
                           *    4 = flache Hand                         *
                           *    5 = dnnes Fadenkreuz                   *
                           *    6 = dickes Fadenkreuz                   *
                           *    7 = Fadenkreuz als Umri                *
                           *  255 = frei definierbare Mausform, Adresse *
                           *        des Definitionsblocks in gr_mofaddr *
                           *  256 = Mausform abschalten                 *
                           *  257 = Mausform anschalten                 */
  addrin[0] = gr_mofaddr; /* Adresse des Mausform-Definitionsblocks,    *
                           * nur bei gr_monumber = 255 bedeutsam.       */

  AES( 78, 1, 1, 1, 0 );

  return intout[0]; /* = gr_moreturn: positiv bei Erfolg, 0 bei Fehler  */
}

