/*
 *  GRAF_MKSTATE                                (C) Digital Design 1990
 *
 *  Die Position des Mauszeigers, der Status der Maustasten und der
 *  Status der Tastatur werden ermittelt.
 */
#include <gemdefs.h>

int graf_mkstate( int *gr_mkmx, int *gr_mkmy,
                  int *gr_mkmstate, int *gr_mkkstate )
{
  AES( 79, 0, 5, 0, 0 );

  *gr_mkmx = intout[1]; /* X-Position des Mauszeigers                   */
  *gr_mkmy = intout[2]; /* Y-Position des Mauszeigers                   */
  *gr_mkmstate = intout[3]; /* Status der Maustasten:                   *
                             *  Bit 0 = linke Taste                     *
                             *  Bit 1 = rechte Taste                    *
                             * Bit gesetzt: Taste gedrckt              *
                             * Bit gelscht: Taste nicht gedrckt       */
  *gr_mkkstate = intout[4]; /* Status folgender Tasten:                 *
                             *  Bit 0 = Shift rechts                    *
                             *  Bit 1 = Shift links                     *
                             *  Bit 2 = Control                         *
                             *  Bit 3 = Alternate                       *
                             * Bit gesetzt: Taste gedrckt              *
                             * Bit gelscht: Taste nicht gedrckt       */
  return intout[0]; /* = gr_mkresvd: reserviert, dieser Wert wird immer *
                     * auf 1 gesetzt.                                   */
}

