/*
 *  EVNT_MULTI                                  (C) Digital Design 1990
 *
 *  AES wartet auf das Eintreten eines oder mehrerer Ereignisse.
 *  Die Funktion kann auf zwei Maus-Ereignisse reagieren, die Parameter
 *  fr das erste Rechteck haben die Bezeichnung ev_mm1..., die fr das
 *  zweite ev_mm2...
 */
#include <gemdefs.h>

int evnt_multi( int ev_mflags, int ev_mbclicks, int ev_mbmask,
                int ev_mbstate, int ev_mm1flags, int ev_mm1x, int ev_mm1y,
                int ev_mm1width, int ev_mm1height, int ev_mm2flags,
                int ev_mm2x, int ev_mm2y, int ev_mm2width, int ev_mm2height,
                int *ev_mmgpbuff, int ev_mtlocount, int ev_mthicount,
                int *ev_mmox, int *ev_mmoy, int *ev_mmobutton,
                int *ev_mmokstate, int *ev_mkreturn, int *ev_mbreturn )
{
  intin[0] = ev_mflags; /* Die Art des kombinierten Ereignisses, auf    *
                         * dessen Eintreten (eines der Unterereignisse) *
                         * gewartet werden soll. Jedes aktive Ereignis  *
                         * ist durch ein gesetztes Bit reprsentiert.   *
                         * Dabei gilt folgende Bit-Belegung:            *
                         *    Bit 0: MU_KEYBD (Tastaturereignis)        *
                         *    Bit 1: MU_BUTTON (Mausknopf-Ereignis)     *
                         *    Bit 2: MU_M1 (Maus-Ereignis, 1. Rechteck) *
                         *    Bit 3: MU_M2 (Maus-Ereignis, 2. Rechteck) *
                         *    Bit 4: MU_MESAG (Nachricht aufgetreten)   *
                         *    Bit 5: MU_TIMER (Zeitgeber-Ereignis)      */ 
  intin[1] = ev_mbclicks;   /* siehe EVNT_BUTTONEVNT_BUT.C           */
  intin[2] = ev_mbmask;     /* siehe EVNT_BUTTONEVNT_BUT.C           */
  intin[3] = ev_mbstate;    /* siehe EVNT_BUTTONEVNT_BUT.C           */
  intin[4] = ev_mm1flags;   /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[5] = ev_mm1x;       /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[6] = ev_mm1y;       /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[7] = ev_mm1width;   /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[8] = ev_mm1height;  /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[9] = ev_mm2flags;   /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[10] = ev_mm2x;      /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[11] = ev_mm2y;      /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[12] = ev_mm2width;  /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[13] = ev_mm2height; /* siehe EVNT_MOUSEEVNT_MOU.C            */
  intin[14] = ev_mtlocount; /* siehe EVNT_TIMEREVNT_TIM.C            */
  intin[15] = ev_mthicount; /* siehe EVNT_TIMEREVNT_TIM.C            */
  addrin[0] = ev_mmgpbuff;  /* siehe EVNT_MESAGEVNT_MES.C            */

  AES( 25, 16, 7, 1, 0 );

  *ev_mmox = intout[1];      /* siehe EVNT_MOUSEEVNT_MOU.C           */
  *ev_mmoy = intout[2];      /* siehe EVNT_MOUSEEVNT_MOU.C           */
  *ev_mmobutton = intout[3]; /* siehe EVNT_MOUSEEVNT_MOU.C           */
  *ev_mmokstate = intout[4]; /* siehe EVNT_MOUSEEVNT_MOU.C           */
  *ev_mkreturn = intout[5];  /* siehe EVNT_KEYBDEVNT_KEY.C           */
  *ev_mbreturn = intout[6];  /* siehe EVNT_BUTTONEVNT_BUT.C          */
  return intout[0]; /* = ev_mwhich: Das Ereignis bzw. die Ereignisse,   *
                     * das/die aufgetreten ist/sind. Die Bit-Belegung   *
                     * ist die gleiche wie bei ev_mflags.               */
}
