/*
 *  EVNT_BUTTON                                 (C) Digital Design 1990
 *
 *  AES wartet, bis einer (oder mehrere) Mausknpfe bettigt werden.
 */
#include <gemdefs.h>

int evnt_button( int ev_bclicks, int ev_bmask, int ev_bstate,
                 int *ev_bmx, int *ev_bmy, int *ev_bbutton,
                 int *ev_bkstate )
{
  intin[0] = ev_bclicks; /* Die Anzahl der "Mausklicks", die zu einer   *
                          * Reaktion der Applikation fhren sollen.     *
                          * Gewhnlich wird der Wert 1 fr einfachen    *
                          * Tastendruck oder 2 fr einen Doppelklick    *
                          * verwendet. Grere Werte sollten Sie nicht  *
                          * angeben, denn nicht jeder Benutzer besitzt  *
                          * die Fhigkeit, den Mausknopf in Sekunden-   *
                          * bruchteilen mehrmals zu bettigen.          */
  intin[1] = ev_bmask; /* Jeder Mausknopf, der bei der Abfrage der      *
                        * Maustasten bercksichtigt werden soll, wird   *
                        * durch ein gesetztes Bit reprsentiert:        *
                        *      01 = linker Knopf                        *
                        *      02 = rechter Knopf                       *
                        *      03 = beide Knpfe                        */
  intin[2] = ev_bstate; /* Hier wird festgelegt, welcher Zustand der in *
                         * ev_bmask spezifizierten Maustasten bei der   *
                         * Auslsung des Ereignisses relevant sein      *
                         * soll. Dabei gilt die gleiche Bitbelegung wie *
                         * oben, die Bitwerte haben folgende Bedeutung: *
                         *      0 = Knopf nicht bettigt                *
                         *      1 = Knopf bettigt                      */
  AES( 21, 3, 5, 0, 0 );

  *ev_bmx = intout[1]; /* X-Koordinate des Mauszeigers zum Zeitpunkt    *
                        * der Tastenbettigung                          */
  *ev_bmy = intout[2]; /* Y-Koordinate des Mauszeigers zum Zeitpunkt    *
                        * der Tastenbettigung                          */
  *ev_bbutton = intout[3]; /* Bettigte Mausknpfe; Werte wie bei       *
                            * ev_bmask und ev_bstate                    */
  *ev_bkstate = intout[4]; /* Status der Tasten der Tastatur, die       *
                            * keinen ASCII-Kode senden. Folgende        *
                            * Bit-Werte gelten:                         *
                            *      1 = rechte Shift-Taste               *
                            *      2 = linke Shift-Taste                *
                            *      4 = Control-Taste                    *
                            *      8 = Alternate-Taste                  *
                            * Bit = 0: Taste nicht bettigt             *
                            * Bit = 1: Taste bettigt                   */
  return intout[0]; /* = ev_breturn: Gibt an, wie oft der Mausknopf     *
                     * bettigt wurde, diese Zahl liegt zwischen 1 und  *
                     * ev_bclicks.                                      */
}
/* siehe auch: EVNT_MULTIEVNT_MUL.C */
