/*
 *  VRO_CPYFM					(C) Digital Design 1991
 *
 *  COPY RASTER, OPAQUE
 *
 *  Diese Funktion kopiert das Quellraster nicht an einen anderen
 *  Speicherplatz, sondern verknpft es logisch mit einem anderen
 *  Speicherbereich, dem Zielraster.
 *  Falls die beiden Raster unterschiedliche Gren aufweisen, wird in
 *  der Gre des Quellrasters verknpft. Die Mglichkeit des Vergr-
 *  erns von Rastern wird mit der erweiterten Nachfrage-Funktion
 *  VQ_EXTND..\INQUIRE\VQ_EXTND.C ermittelt.
 *  Die Funktion arbeitet nur mit gertespezifischen Rasterformen.
 *  Entsprechende Umwandlungen sind mit der TRANSFORM-FORM-Funktion
 *  VR_TRNFMVR_TRNFM.C mglich.
 */
#include <gemdefs.h>

void vro_cpyfm( int handle, int vr_mode, int *pxyarray,
		MFDB *psrcMFDB, MFDB *pdesMFDB )
{
  *(MFDB far **)(contrl + 7) = psrcMFDB; /* Doppelwort-Adresse MFDB	*/
					 /* des Quellrasters		*/
  *(MFDB far **)(contrl + 9) = pdesMFDB; /* Doppelwort-Adresse MFDB	*/
					 /* des Zielrasters		*/
  intin[0] = vr_mode; /* Modus der logischen Verknpfung		*
		       * (q = Quellraster, z = Zielraster, r =		*
		       * resultierendes, abgespeichertes Zielraster):	*
		       *	0:	r = 0				*
		       *	1:	r = q AND z			*
		       *	2:	r = q AND (NOT z)		*
		       *	3:	r = q (1:1 bertragung) 	*
		       *	4:	r = (NOT q) AND z		*
		       *	5:	r = z				*
		       *	6:	r = q XOR z			*
		       *	7:	r = q OR z			*
		       *	8:	r = NOT (q OR z)		*
		       *	9:	r = NOT (q XOR z)		*
		       *	10:	r = NOT z			*
		       *	11:	r = q OR (NOT z)		*
		       *	12:	r = NOT q			*
		       *	13:	r = (NOT q) OR z		*
		       *	14:	r = NOT (q AND z)		*
		       *	15:	r = 1				*/
  vdipb[2] = pxyarray; /* pxyarray[0] = x-Koordinate des Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[1] = y-Koordinate des Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[2] = x-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[3] = y-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Quellrasters		*
			* pxyarray[4] = x-Koordinate des Eckpunktes	*
			*		des Zielrasters 		*
			* pxyarray[5] = y-Koordinate des Eckpunktes	*
			*		des Zielrasters 		*
			* pxyarray[6] = x-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Zielrasters 		*
			* pxyarray[7] = y-Koordinate des diagonal	*
			*		gegenberliegenden Eckpunktes	*
			*		des Zielrasters 		*/
  VDI( 109, 4, 1, handle );

  vdipb[2] = ptsin;
}
