/*
 *  V_CELLARRAY 				(C) Digital Design 1991
 *
 *  Diese Funktion ist sehr komplex und darum auch schwer zu beschreiben.
 *  Zunchst wird ein definiertes Rechteck gezeichnet. Dieses Rechteck
 *  wird logisch in eine Tabelle mit beliebig vielen Zeilen und Spalten
 *  eingeteilt. Jedem der dadurch entstehenden Tabellenelemente wird eine
 *  frei definierbare Farbe zugeordnet. Die Bildschirmpunkte, die inner-
 *  halb dieser Tabelle liegen, nehmen die Farbe der sie eingrenzenden
 *  Tabellenelemente an. Ein Beispiel: Der Grafikbildschirm wird in vier
 *  gleiche Teile, also vier Farbzonen zerlegt. Die ausgegebenen Grafik-
 *  punkte nehmen jeweils die Farbe der Zone an, in der sie sich befinden.
 *  Nicht jedes Arbeitsgert, so z.B. der Monochrommonitor, erlauben den
 *  Einsatz dieser Funktion. Es wird dann lediglich das Rechteck in der
 *  aktuellen Linienfarbe und Linienbreite gezeichnet.
 */
#include <gemdefs.h>

void v_cellarray( int handle, int *pxyarray, int row_length, int el_used,
		  int num_rows, int wrt_mode, int *colarray )
{
  contrl[7] = row_length; /* Lnge der Zeilen im Farbarray		*/
  contrl[8] = el_used; /* Anzahl der Zonen in den Zeilen des Farbarrays */
  contrl[9] = num_rows; /* Anzahl der Zeilen im Farbarray		*/
  contrl[10] = wrt_mode; /* Zeichenmodus (siehe VSWR_MODE..\ATTRIB\VSWR_MOD.C)	       */
  vdipb[1] = colarray; /* Farbarray, enthlt zeilenweise die Farbe	*
			* jeder Tabellenzone				*/
  vdipb[2] = pxyarray; /* pxyarray[0] = x-Koordinate der unteren linken *
			*		Ecke des Rechteckes		*
			* pxyarray[1] = y-Koordinate der unteren linken *
			*		Ecke des Rechteckes		*
			* pxyarray[2] = x-Koordinate der oberen rechten *
			*		Ecke des Rechteckes		*
			* pxyarray[3] = y-Koordinate der oberen rechten *
			*		Ecke des Rechteckes		*/
  VDI( 10, 2, num_rows * el_used, handle );

  vdipb[1] = intin;
  vdipb[2] = ptsin;
}
