/*
 *  VQ_COLOR                                    (C) Digital Design 1990
 *
 *  INQUIRE COLOR REPRESENTATION
 *
 *  Diese Funktion stellt die Einstellung der Farbmischung fr den
 *  aktuellen oder spezifizierten Farbindex fest.
 */
#include <gemdefs.h>

int vq_color( int handle, int color_index, int set_flag, int rgb[3] )
{
  intin[0] = color_index; /* zu analysierender Farbindex                */
  intin[1] = set_flag; /* Flag aktueller oder bergebener Farbindex:    *
                        *       0 = bergebener Farbindex               *
                        *       1 = aktueller Farbindex                 */
  VDI( 26, 0, 2, handle );

  rgb[0] = intout[1]; /* Rot-Intensitt (0-1000)                        */
  rgb[1] = intout[2]; /* Grn-Intensitt (0-1000)                       */
  rgb[2] = intout[3]; /* Blau-Intensitt (0-1000)                       */

  return intout[0];
}
/* siehe auch: vs_color..\ATTRIB\VS_COLOR.C */
