/*
 *  VQT_WIDTH					(C) Digital Design 1991
 *
 *  INQUIRE CHARACTER CELL WIDTH
 *
 *  Diese Funktion ermittelt die Mae eines spezifizierten Zeichens
 *  und dessen umfassende Zeichenbox. Texteffekte und Rotation
 *  werden hier nicht bercksichtigt.
 */
#include <gemdefs.h>

int vqt_width( int handle, int character, int *cell_width,
	       int *left_delta, int *right_delta )
{
  intin[0] = character; /* zu messendes Zeichen 			*/

  VDI( 117, 0, 1, handle );

  *cell_width = ptsout[0]; /* Breite der Zeichenbox			*/
	     /* ptsout[1] = 0 */
  *left_delta = ptsout[2]; /* Abstand vom Zeichen zum linken Rand	*
			    * der Zeichenbox				*/
	     /* ptsout[3] = 0 */
  *right_delta = ptsout[4]; /* Abstand vom Zeichen zum rechten Rand	*
			     * der Zeichenbox				*/
	     /* ptsout[5] = 0 */
  return intout[0]; /* vermessenes Zeichen (-1 wenn Zeichen ungltig)	*/
}

