/*
 *  VSM_VALUATOR                                (C) Digital Design 1990
 *
 *  INPUT VALUATOR, SAMPLE MODE
 *
 *  Diese Funktion entspricht weitgehend der entsprechenden request-Mode-
 *  Funktion. Der Unterschied ist, da nicht auf einen Tastendruck gewar-
 *  tet wird. Die Funktion ermittelt, welche Aktionen die Eingabeeinheit
 *  ausgefhrt hat. Das Prinzip entspricht der Funktion INPUT LOCATORVSM_LOCA.C.
 */
#include <gemdefs.h>

void vsm_valuator( int handle, int val_in,
                   int *val_out, int *term, int *status )
{
  intin[0] = val_in; /* initialisierender Wert                          */

  VDI( 29, 0, 1, handle );

  *val_out = intout[0]; /* neuer Wert                                   */
  *term = intout[1]; /* bettigte Taste, ASCII-Code                     */
  *status = contrl[4]; /* 0 = keine Aktion                              *
                        * 1 = Wert wurde gendert                       *
                        * 2 = Taste wurde bettigt                      */
}
/* siehe auch: vrq_valuatorVRQ_VALU.C, vsin_modeVSIN_MOD.C */

