/*
 *  VRQ_STRING                                  (C) Digital Design 1990
 *
 *  INPUT STRING, REQUEST MODE
 *
 *  Diese Funktion liest einen String von der Tastatur. Als Endekriterium
 *  gilt die Taste RETURN (ASCII 13) oder das Erreichen der maximalen
 *  Stringlnge.
 *  Bei eingeschaltetem Echo-Modus werden die von der Tastatur eingege-
 *  benen Zeichen zustzlich auf dem Bildschirm in einen spezifizierten
 *  Bereich ausgegeben. Alle Attribute-Funktionen fr Text haben auch in
 *  diesem Echo-Modus Gltigkeit.
 *  Wenn die maximale Stringlnge negativ ist, so wird im intout-Array
 *  der 2-Byte-Code der VDI..\VDI.HLP-Standard-Tastatur (siehe Anhang) angelegt.
 */
#include <gemdefs.h>

void vrq_string( int handle, int max_length, int echo_mode,
                 int echo_xy[2], char *string )
{
  intin[0] = max_length; /* maximale Stringlnge                        */
  intin[1] = echo_mode; /* Echo-Modus:                                  *
                         *      0 = Echo-Modus ausgeschaltet            *
                         *      1 = Echo-Modus eingeschaltet            */
  ptsin[0] = echo_xy[0]; /* x-Koordinate des Echo-Bereiches             */
  ptsin[1] = echo_xy[1]; /* y-Koordinate des Echo-Bereiches             */

  VDI( 31, 1, 2, handle );

  string[max_length] = 0; /* eingegebener String                        */
  while (max_length-- > 0) string[max_length] = intout[max_length];
}
/* siehe auch: vsm_stringVSM_STRI.C, vsin_modeVSIN_MOD.C */

