/*
 *  VRQ_LOCATOR                                 (C) Digital Design 1990
 *
 *  INPUT LOCATOR, REQUEST MODE
 *
 *  Diese Funktion ermittelt die Position des Grafikcursors. Da sie im
 *  request-Mode arbeitet, gibt sie die Position erst zurck, wenn eine
 *  Taste gedrckt wird.
 *  Whrend des Aufrufes der Funktion wird der Cursor unabhngig vom
 *  Zustand auf jeden Fall an der spezifizierten Stelle sichtbar.
 *  Diese Funktion wird immer dann in Programmen eingesetzt, wenn der
 *  Anwender eine Stelle auf dem Bildschirm markieren soll.
 *  Da die Funktion mit jeder beliebigen Taste beendet wird, mu der
 *  Programmierer selbst die Kontrolle ber eine bedingte Abbruchtaste
 *  bernehmen. Das heit, er ruft die Funktion immer wieder auf, bis
 *  "seine" Taste gedrckt wird.
 */
#include <gemdefs.h>

void vrq_locator( int handle, int x, int y, int *xout, int *yout, int *term )
{
  ptsin[0] = x; /* initialisierende Position des Grafikcursors          *
                 * (x-Koordinate)                                       */
  ptsin[1] = y; /* initialisierende Position des Grafikcursors          *
                 * (y-Koordinate)                                       */
  VDI( 28, 1, 0, handle );

  *term = intout[0]; /* Funktions-Ende-Taste:                           *
                      * Im Low-Byte dieses Parameters wird der ASCII-   *
                      * Code der Taste eingetragen, die die Positionie- *
                      * rung abschliet (z.B. RETURN = 13).             *
                      * Spezielle Ende-Tasten sind z.B. die beiden      *
                      * Maus-Knpfe oder Tasten eines Grafiktabletts.   *
                      * Der Code dieser Tasten beginnt ab 20h (32). Die *
                      * linke Taste der Maus hat den Code 20h (32), die *
                      * rechte 21h (33).                                */
  *xout = ptsout[0]; /* ermittelte x-Position                           */
  *yout = ptsout[1]; /* ermittelte y-Position                           */
}
/* siehe auch: vsm_locatorVSM_LOCA.C, vsin_modeVSIN_MOD.C */

