/*
 *  VQ_MOUSE					(C) Digital Design 1993
 *
 *  SAMPLE MOUSE BUTTON STATE (VDI 124)
 *
 *  Diese Funktion wird zur Ermittlung des Status der Maus-Tasten
 *  eingesetzt. Weiterhin gibt sie die aktuelle Position des
 *  Grafikcursors zurck.
 */
#include <gemdefs.h>

void vq_mouse( int handle, int *pstatus, int *x, int *y )
{
  VDI( 124, 0, 0, handle );

  *pstatus = intout[0]; /* Status der Maustasten:			*
			 *  Bit 0 = linke Taste 	       		*
			 *  Bit 1 = Taste rechts daneben		*
			 *  weitere Bits: weitere Tasten		*/
  *x = ptsout[0]; /* x-Position des Grafikcursors in NDC/RC-Koordinaten */
  *y = ptsout[1]; /* y-Position des Grafikcursors in NDC/RC-Koordinaten */
}
