/*
 *  VST_HEIGHT                                  (C) Digital Design 1990
 *
 *  SET CHARACTER HEIGHT, ABSOLUTE MODE
 *
 *  Diese Funktion ermglicht es, den auszugebenden Grafiktext in der
 *  Hhe zu variieren. Es wird die Zeichenhhe, also der Abstand von der
 *  Zeichengrundlinie bis zum Ende der Zeichen-Box definiert.
 *  Handelt es sich um einen proportionalen Zeichensatz, so beziehen
 *  sich zurckgelieferten Parameter auf das grte Zeichen.
 */
#include <gemdefs.h>

void vst_height( int handle, int height, int *char_width, int *char_height,
                 int *cell_width, int *cell_height )
{
  ptsin[0] = 0;
  ptsin[1] = height; /* Zeichenhhe                                     */

  VDI( 12, 1, 0, handle );

  *char_width = ptsout[0];  /* Aktuelle Zeichenbreite                   */
  *char_height = ptsout[1]; /* Aktuelle Zeichenhhe                     */
  *cell_width = ptsout[2];  /* Aktuelle Zeichenbox-Breite               */
  *cell_height = ptsout[3]; /* Aktuelle Zeichenbox-Hhe                 */
}
/* siehe auch: vst_pointVST_POIN.C */

