/*
 *  VSM_TYPE                                    (C) Digital Design 1990
 *
 *  SET POLYMARKER TYPE
 *
 *  Markierungen mit der Funktion V_PMARKER..\OUTPUT\V_PMARKE.C knnen nicht nur als Punkt,
 *  sondern auch z.B. als Stern oder Kreuz dargestellt werden.
 *  Der Punkt als kleinste Markierungsart kann nicht vergrert werden.
 *  Wird eine ungltige Markierungsart gewhlt, so setzt das VDI stan-
 *  dardmig den Stern (3) ein.
 *  Die Anzahl der Markierungsarten ist unterschiedlich. Die Funktionen
 *  V_OPNWK..\CONTROL\V_OPNWK.C und V_OPNVWK..\CONTROL\V_OPNVWK.C teilen dies in work_out[8] mit.
 */
#include <gemdefs.h>

int vsm_type( int handle, int symbol )
{
  intin[0] = symbol; /* Markierungstyp:  1 = Punkt                      *
                      *                  2 = Plus-Zeichen               *
                      *                  3 = Stern                      *
                      *                  4 = Quadrat                    *
                      *                  5 = Diagonal-Kreuz             *
                      *                  6 = Diamant                    *
                      *                  7 bis n = gerteabhngig       */
  VDI( 18, 0, 1, handle );

  return intout[0]; /* = set_type: Ausgewhlter Markierungstyp          */
}

