/*
 *  RSRC_GADDR                                  (C) Digital Design 1990
 *
 *  Die Adresse einer Datenstruktur im Speicher wird ermittelt.
 *  Dabei kann es sich um Objektbume oder objektspezifische
 *  Informationen handeln.
 */
#include <gemdefs.h>

int rsrc_gaddr( int re_gtype, int re_gindex, OBJECT **gaddr )
{
  intin[0] = re_gtype; /* dieser Wert legt fest. von welcher Art die    *
                        * Datenstruktur ist, deren Adresse gesucht      *
                        * werden soll:                                  *
                        *  0 = Baumstruktur (des mit RSRC_LOADRSRC_LOA.C zuletzt  *
                        *      geladenen Baumes)                        *
                        *  1 = Objekt                                   *
                        *  2 = TEDINFO (Textinformation)                *
                        *  3 = ICONBLK (Piktogramminformation)          *
                        *  4 = BITBLK (Bitmustergrafikinformation)      *
                        *  5 = string (Text)                            *
                        *  6 = imagedata (Zeiger auf eine Bitmuster-    *
                        *      grafik                                   *
                        *  7 = obspec (Objektspezifikation)             *
                        *  8 = te_ptext (Zeiger auf einen Text)         *
                        *  9 = te_ptmplt (Zeiger auf eine Textschablone)*
                        * 10 = te_pvalid (Zeiger auf einen Texteingabe- *
                        *      begrenzungsstring)                       *
                        * 11 = ib_pmask (Piktogramm-Darstellungsmaske)  *
                        * 12 = ib_pdata (Piktogramm-Bitmuster)          *
                        * 13 = ib_ptext (Piktogrammtext)                *
                        * 14 = bi_pdata (Zeiger auf Bitmustergrafik)    *
                        * 15 = ad_frstr (Adresse eines Zeigers auf      *
                        *      einen freien String)                     *
                        * 16 = ad_frimg (Adresse eines Zeigers auf      *
                        *      eine freie Bitmustergrafik)              */
  intin[1] = re_gindex; /* Index des betreffenden Objektes              */

  AES( 112, 2, 1, 0, 1 );

  *gaddr = (OBJECT *)(addrout[0]); /* die gesuchte Adresse der Daten-   *
                                    * strukutr                          */
  return intout[0]; /* = re_greturn: positiv bei Erfolg, 0 bei Fehler   */
}
/* siehe auch: rsrc_saddrRSRC_SAD.C */

