/*
 *  OBJC_CHANGE                                 (C) Digital Design 1990
 *
 *  Der Wert der Variable ob_state wird gendert. Es werden nur
 *  diejenigen Objektteile in ihrem Aussehen verndert, die sich
 *  innerhalb eines angegebenen Begrenzungsrechtecks befinden.
 */
#include <gemdefs.h>

int objc_change( OBJECT *ob_ctree, int ob_cobject,
                 int ob_cresvd, int ob_cxclip, int ob_cyclip,
                 int ob_cwclip, int ob_chclip,
                 int ob_cnewstate, int ob_credraw )
{
  intin[0] = ob_cobject; /* der Index des Objektes, dessen Status       *
                          * gendert werden soll.                       */
  intin[1] = ob_cresvd; /* reserviert fr zuknftige Anwendungen, mu   *
                         * auf Null gesetzt werden.                     */
  intin[2] = ob_cxclip; /* X-Koordinate des Begrenzungsrechtecks        */
  intin[3] = ob_cyclip; /* Y-Koordinate des Begrenzungsrechtecks        */
  intin[4] = ob_cwclip; /* Breite des Begrenzungsrechtecks              */
  intin[5] = ob_chclip; /* Hhe des Begrenzungsrechtecks                */
  intin[6] = ob_cnewstate; /* neuer Objektstatus des Objekts            */
  intin[7] = ob_credraw; /* 0 = Objekt soll nicht neu gezeichnet werden *
                          * 1 = Objekt soll neu gezeichnet werden       */
  addrin[0] = ob_ctree; /* Adresse des Objektbaumes                     */

  AES( 47, 8, 1, 1, 0 );

  return intout[0]; /* = ob_creturn: positiv bei Erfolg, 0 bei Fehler.  */
}

