/*
 *  GRAF_SLIDEBOX				(C) Digital Design 1990
 *
 *  Der Benutzer kann mit Hilfe des Mauszeigers ein Rechteck innerhalb
 *  eines anderen Rechtecks verschieben, wobei die Richtung entweder
 *  nur horizontal oder nur vertikal sein darf. Das umfassende Rechteck
 *  mu das bergeordnete Objekt des verschiebbaren Rechtecks in einem
 *  Objektbaum sein. Die Funktion sollte nur bei bettigtem Mausknopf
 *  ausgelst werden, sie ist beendet, wenn der Benutzer den Mausknopf
 *  wieder loslt.
 */
#include <gemdefs.h>

int graf_slidebox( OBJECT *gr_slptree, int gr_slparent,
		   int gr_slobject, int gr_slvh )
{
  intin[0] = gr_slparent; /* der Index des umfassenden Rechtecks im	*
			   * Objektbaum 				*/
  intin[1] = gr_slobject; /* der Index des verschiebbaren Objektes im	*
			   * Objektbaum 				*/
  intin[2] = gr_slvh; /* Flag zur Bestimmung der mglichen Bewegungs-	*
		       * richtung:					*
		       *	0 = horizontal				*
		       *	1 = vertikal				*/
  addrin[0] = gr_slptree; /* die Adresse des Objektbaums		*/

  AES( 76, 3, 1, 1, 0 );

  return intout[0]; /* = gr_slreturn: die Position des Mittelpunktes	*
		     * des verschiebbaren Rechtecks relativ in Bezug	*
		     * auf das umfassende Rechteck:			*
		     *	  wenn gr_slv = 0 (horizontal): 		*
		     *		0 = Position ganz links 		*
		     *	     1000 = Position ganz rechts		*
		     *	  wenn gr_slv = 1 (vertikal):			*
		     *		0 = Position ganz oben			*
		     *	     1000 = Position ganz unten 		*/
}
/* siehe auch: graf_dragboxGRAF_DRA.C */

