/*
 *  GRAF_RUBBERBOX                              (C) Digital Design 1990
 *
 *  Es wird ein Kasten gezeichnet, dessen linke obere Ecke fest steht.
 *  Die rechte untere Ecke folgt den Mausbewegungen des Benutzers.
 *  Sobald dieser den Mausknopf (links) loslt, ist die Funktion beendet
 *  (sie sollte deshalb nur bei gedrcktem Mausknopf ausgelst werden).
 *  Als Ausgabeparameter liefert sie die Gre des Rechtecks.
 */
#include <gemdefs.h>

int graf_rubberbox( int gr_rx, int gr_ry, int gr_minwidth, int gr_minheight,
                    int *gr_rlastwidth, int *gr_rlastheight )
{
  intin[0] = gr_rx;        /* X-Koordinate des Rechtecks                */
  intin[1] = gr_ry;        /* Y-Koordinate des Rechtecks                */
  intin[2] = gr_minwidth;  /* kleinstmgliche Breite des Rechtecks      */
  intin[3] = gr_minheight; /* kleinstmgliche Hhe des Rechtecks        */

  AES( 70, 4, 3, 0, 0 );

  *gr_rlastwidth = intout[1];  /* Breite des Rechtecks bei Loslassen    *
                                * des Mausknopfes                       */
  *gr_rlastheight = intout[2]; /* Hhe des Rechtecks bei Loslassen      *
                                * des Mausknopfes                       */
  return intout[0]; /* = gr_rreturn: positiv bei Erfolg, 0 bei Fehler   */
}
/* siehe auch: graf_dragboxGRAF_DRA.C, graf_moveboxGRAF_MOV.C */

