/*
 *  FORM_DIAL					(C) Digital Design 1990
 *
 *  Diese Funktion beinhaltet eigentlich vier Funktionen, die mit 0 bis
 *  3 numeriert sind und die bei der Formularverwaltung in der vorge-
 *  stellten Reihenfolge bentigt werden (Funktion 1 und 2 sind optional):
 *	- Reservierung eines Bildschirmspeicherbereichs
 *	- Zeichnen eines sich ausdehnenden Rechtecks
 *	- Zeichnen eines schrumpfenden Rechtecks
 *	- Freigeben des reservierten Bildschirmspeicherbereichs
 */
#include <gemdefs.h>

int form_dial( int fo_diflag, int fo_dilittlx, int fo_dilittly,
	       int fo_dilittlw, int fo_dilittlh, int fo_dibigx,
	       int fo_dibigy, int fo_dibigw, int fo_dibigh )
{
  intin[0] = fo_diflag; /* Nummer der Funktion, die ausgefhrt werden	*
			 * soll:					*
			 *	0: Reservierung eines Bildschirmspei-	*
			 * cherbereichs (dient dem spteren Wiederher-	*
			 * stellen der Fensterrandkomponenten)		*
			 *	1: Zeichnen eines sich ausdehnenden	*
			 * Kastens. Dieser wird in mehreren Stufen von	*
			 * dilittl... bis zur Gre dibig... gezeichnet *
			 * (optional).					*
			 *	2: Zeichnen eines schrumpfenden Kastens.*
			 * Dieser wird in mehreren Stufen von dibig...	*
			 * bis dilittl... gezeichnet (optional).	*
			 *	3: Freigeben des reservierten Bild-	*
			 * schirmspeichers. Die zerstrten Randelemente *
			 * des Fensters werden wiederhergestellt.	*/
  intin[1] = fo_dilittlx; /* X-Koordinate des Rechtecks in seiner	*
			   * kleinsten Gre				*/
  intin[2] = fo_dilittly; /* Y-Koordinate des Rechtecks in seiner	*
			   * kleinsten Gre				*/
  intin[3] = fo_dilittlw; /* Breite des Rechtecks in seiner kleinsten	*
			   * Gre					*/
  intin[4] = fo_dilittlh; /* Hhe des Rechtecks in seiner kleinsten	*
			   * Gre					*/
  intin[5] = fo_dibigx; /* X-Koordinate des Rechtecks in seiner grten *
			 * Gre					*/
  intin[6] = fo_dibigy; /* Y-Koordinate des Rechtecks in seiner grten *
			 * Gre					*/
  intin[7] = fo_dibigw; /* Breite des Rechtecks in seiner grten Gre */
  intin[8] = fo_dibigh; /* Hhe des Rechtecks in seiner grten Gre	*/

  AES( 51, 9, 1, 1, 0 );

  return intout[0]; /* = fo_direturn: positiv bei Erfolg, 0 bei Fehler. */
}
/* siehe auch: objc_draw..\OBJC\OBJC_DRA.C, form_doFORM_DO.C */

