/*
gemgraph.h : entres/sorties simplifies pour GEM
Auteur : Guillaume LAMONOCA (E-mail:gl@gen4.pressimage.fr)

gemgraph.h devra se trouver dans l'un des repertoires
"include" spcifis dans Options->Compiler.

Exemple fourni : exsimple.c (utilisez Pure C)

Remarque : la fonction main() devra changer de nom, elle
devra s'appeler principal() (contrainte du C++ sous Windows).

Note technique : interface drive des modules GLCB (DP)
*/

#ifndef GEMGRAPH_H
#define GEMGRAPH_H

#include <stdarg.h>

#ifndef NOM_FENETRE
#define NOM_FENETRE ""
#endif

#ifndef NOM_ACC
#define NOM_ACC		"  GEMgraph program"
#endif

#ifndef NOM_ICONE
#define NOM_ICONE	"GEMgraph"
#endif


/* dimensions de la fenetre */

#ifndef WIDTH
#define WIDTH	600
#endif

#ifndef HEIGHT
#define HEIGHT	400
#endif

#define LARGEUR WIDTH
#define HAUTEUR HEIGHT




/*******************************************************************************/
/* Memoire virtuelle disponible */

unsigned long freevirtualram(void);


/************************************************************/
/* Codes de touches speciales pour                          */ 
/* les fonctions sgetch() et sgetche()                      */

#define T_CTRL			0x2000
#define T_ALTGR			0x3000
#define T_SHIFT			0x4000
#define T_ALT			0x1000

#define T_EFFACE		0x0008 /* Backspace */
#define T_TAB			0x0009
#define T_ENTREE		0x000d
#define T_ECHAP			0x001b /* Esc */

#define T_INSER			0x8052 /* Insert */
#define T_DEBUT			0xa04b /* Control + Fleche gauche */
#define T_PAGE_HAUT		0x8061 /* Undo */
#define T_SUPPR			0x007f /* Delete */
#define T_FIN       	0xa04d /* Control + Fleche droite */
#define T_PAGE_BAS		0x8047 /* Clr Home */

#define T_HAUT			0x8048
#define T_BAS			0x8050
#define T_GAUCHE		0x804b
#define T_DROITE		0x804d
#define T_CENTRE		0

#define T_VERR_NUM		0
#define T_CAPSLOCK		0
#define T_PAUSE			0x8062 /* Help */
#define T_ARRET_DEFIL	0 

#define T_F1			0x803b
#define T_F2			0x803c
#define T_F3			0x803d
#define T_F4			0x803e
#define T_F5			0x803f
#define T_F6			0x8040
#define T_F7			0x8041
#define T_F8			0x8042
#define T_F9			0x8043
#define T_F10			0x8044
#define T_F11			0
#define T_F12			0
			



/************************************************************/
/* simulation du mode texte */

#ifndef TABNBR
#define TABNBR 8
#endif

int largeur_caractere(void);
int hauteur_caractere(void);

void gotoxy(int x, int y);
int wherex(void);
int wherey(void);
void clrscr(void);
void clreol(void);


			       
void outtextxy(int,int,char *);


int scanf(const char *format, ...);
int printf(const char *format, ...);
int vscanf(const char *format, va_list arglist);
int vprintf(const char *format, va_list arglist);
			  


/***************************************************************/
/* gestion des 16 couleurs */

#define couleur(c) ggsetcolor(c)
#define couleur_fond(c) ggsetbkcolor(c)

void ggsetcolor(int c);
void ggsetbkcolor(int c);
void gggetpalette(unsigned int *pal);
void ggsetpalette(unsigned int *pal);

#define XOR_MODE		0x4000

#define COULEUR_PRECEDENTE	0x40

#define BLANC        0
#define NOIR         1
#define ROUGE        2
#define VERT_CLAIR   3
#undef  MAGENTA
#define MAGENTA      4
#define CYAN_CLAIR   5
#define JAUNE        6
#define VIOLET_CLAIR 7
#define GRIS_CLAIR   8
#define GRIS         9
#define MARRON       10
#define VERT         11
#define BLEU         12
#undef  CYAN
#define CYAN         13
#define KAKI         14
#define VIOLET       15


/************************************************************/
/* instructions de gestion des ecrans graphiques */

void ggsimplescreen(void);
void ggdoublescreen(void);
void ggcls(void);
void ggrefresh(void);
#define rafraichir() ggrefresh()
void ggswap(void);


/******************************************************************/
/* instructions graphiques de base */

void ggpellipse(int x,int y,int lx,int ly,int c);
void ggellipse(int x,int y,int lx,int ly,int c);
void ggpbox(int x,int y,int lx,int ly,int c);
void ggplot(int x,int y,int c);
void ggline(int x1,int y1,int x2,int y2,int c);
void ggdbox(int x,int y,int lx,int ly,int c);
void ggpolyline(int n,int *tp,int c);
void ggpolyfill(int n,int *tp,int c);

#define cercle(x,y,r) ggellipse(x,y,r,r,-1)
#define cercle_plein(x,y,r) ggpellipse(x,y,r,r,-1)
#define ellipse(x,y,rx,ry) ggellipse(x,y,rx,ry,-1)
#define ellipse_pleine(x,y,rx,ry) ggpellipse(x,y,rx,ry,-1)
#define rectangle(x,y,lx,ly) ggdbox(x,y,lx,ly,-1)
#define rectangle_plein(x,y,lx,ly) ggpbox(x,y,lx,ly,-1)
#define pixel(x,y) ggplot(x,y,-1)
#define droite(x1,y1,x2,y2) ggline(x1,y1,x2,y2,-1)
			 
	   

/**************************************************************/
/* gestion de la souris et du clavier */

int gggetmouse(void);
int ggbuthit(void);

int getch(void);
char *gets(char *s);
int sgetch(void);
int putch(int c);
int getche(void);            
int sgetche(void);
int kbhit(void);
int puts(const char *s);
int sputs(char *s);
int ungetch(int);


int ggkeyhit(void);
void ggconfirm(void);
void ggempty(void);

#undef putchar
#undef getchar

#define putchar putch
#define getchar getch


int souris(int *x, int *y, int *b);

#define BOUTON_GAUCHE_ENFONCE 1
#define BOUTON_DROIT_ENFONCE  2
#define BOUTON_GAUCHE_RELACHE 5
#define BOUTON_DROIT_RELACHE  6




/* principal() sera dfini par l'utilisateur (remplace main) */
void principal(void);



#endif GEMGRAPH_H

