/*
gemgraph.c : entres/sorties simplifies pour GEM
Auteur : Guillaume LAMONOCA (E-mail:gl@gen4.pressimage.fr)

gemgraph.h devra se trouver dans l'un des repertoires
"include" spcifis dans Options->Compiler.

Exemple fourni : exsimple.c (utilisez Pure C)

Remarque : la fonction main() devra changer de nom, elle
devra s'appeler principal() (contrainte du C++ sous Windows).

Note technique : interface drive des modules GLCB (DP)
*/

/*
Utiliser Pure C
Pour de gros executables: Options->Compiler "Use absolute calls"
(par prudence choisissez toujours cette option)
  
Faites un fichier .PRJ pour compiler et linker
pcstart.o, exsimple.c, et gemgraph.c ensemble
afin d'obtenir l'executable exemple.prg.

contenu d'un tel fichier exemple.prj:

exemple.prg (ou exemple.acc)
=
pcstart.o
gemgraph.c
exsimple.c

PCSTDLIB.LIB       ; standard library
PCFLTLIB.LIB       ; floating point library
PCEXTLIB.LIB       ; extended library
PCTOSLIB.LIB       ; TOS library
PCGEMLIB.LIB       ; AES and VDI library

EDDILIB.LIB		   ; VDI Enhancer library
*/


/*#define KILLED_WHEN_CLOSED*/
/* pour provoquer l'arret du programme a chaque fermeture de la fenetre
   et un redemarrage du programme a chaque rappel de l'accessoire
   (si on donne au fichier executable l'extension ACC)
   (sinon ce redemarrage n'intervient que dans certains cas :
    a chaque appel de programme et changement de resolution du bureau)
*/


/*#define CTRL_Q_CONFIRM*/
/* CTRL+Q entraine normalement l'arret brusque du programme. Cependant
   en definissant cette constante, une fentre de confirmation sera
   active, et l'arret ne sera valide que si l'utilisateur repond 'Yes' */


#define SYSTEM_CURSOR_COLOR NOIR
/* no de la couleur pour le curseur GEM */

/*#define NO_CURSOR*/
/* Si vous definissez la constante NO_CURSOR, le pointeur
   d'origine de la souris sera invisible dans la fenetre
*/

/* -------------------------------------------------------------------- */
/*       Inclusion des fichiers de dclarations.                        */
/* -------------------------------------------------------------------- */

#undef MAGENTA
#undef CYAN

#include <aes.h>
#include <vdi.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

#include <portab.h>
#include <tos.h>
#include <eddilib.h>

#include <math.h> 

#include <setjmp.h>

#include "gemgraph.h"

/* -------------------------------------------------------------------- */
/*       Dclarations des variables globales externes.                  */
/* -------------------------------------------------------------------- */
                                    /* Cette variable globale permet    */
extern int _app;                    /*   au programme de dterminer     */
                                    /*   s'il a t lanc comme         */
                                    /*   programme ou comme accessoire  */

static int emulmono=0;  /* pour forcer un mode monochrome */

static int modemono;

                                    

/* -------------------------------------------------------------------- */
/*       Constantes pour l'AES 4.1                                      */
/* -------------------------------------------------------------------- */                                   

/* Ce module gere bien l'AES>=4.0 (iconification,Select+shift,Select+ctrl, etc...)

   Mais :

   Notez le defaut de l'AES 4.0 et 4.1 : 
   -----------------------------------
   
   Lorsqu'on slectionne un programme ou le bureau dans le menu des accessoires,
   cela selectionne la fenetre correspondante, mais le systeme n'envoie pas de
   message WM_UNTOPPED a la fenetre precedement active... Tragique!
   Car a ce moment la, je n'ai plus aucun moyen (pas de message envoye)
   pour savoir que la fenetre n'est plus active, et donc restaurer la palette
   de couleur... Donc theoriquement il ne faudrait pas utiliser le menu des
   accessoires pour selectionner un programme ou le bureau (il faudrait cliquer
   plutot dans les fenetres). Bref une horreur...
   
   Rassurez-vous, j'ai trouve une solution elegante a ce probleme. Puisque la 
   selection d'un programme ou du bureau par le menu des accessoires, desactive
   les fenetres actives sans leur envoyer le message WM_UNTOPPED (ce qui est
   la moindre des choses; esperons que ce petit bug soit repare dans les versions
   futures de l'AES, en attendant je vous invite a prendre ma solution), on va
   s'arranger pour que toute tentative de selection dans ce menu soit precedee par
   une desactivation 'virtuelle' de la fenetre (provoquee par le programme, donc il
   sera au courant cette fois et pourra restaurer la palette).
   De plus, en meme temps que de contourner ce petit bug des AES 4.0 et 4.1, cela
   resoudra un petit probleme d'ergonomie : souvent la palette (par exemple la
   palette EGA par defaut du module) rend illisible les menus (couleurs 0 et 1 trop
   proches). Or desactiver 'virtuellement' la fenetre avant de toucher au menu
   provoquera une restauration de la palette systeme et donc rendra lisible les
   menus. On va donc desactiver notre fenetre des que l'utilisateur a l'intention
   de toucher a la barre de menu du systeme. Pour cela on detectera l'entree
   de la souris dans le rectangle correspondant a la barre de menu.


   Bug in AES 4.0 and 4.1 :
   ----------------------
   
   If you select a program or desktop in accessory menu, WM_UNTOPPED message is
   NOT sent to top window, but the window is no longer topped...
   So palette restoration is impossible.

   Solution : detect mouse pointer entering menu bar, and 'virtualy' untop the window.
   So, user will be able to read menus (system palette restored), and won't cause
   any problem if he selects program or desktop via accessory menu, since the
   window has already aknowledged a 'virtual' untop event (don't need WM_UNTOPPED).
   
*/   

#ifndef SMALLER
#define SMALLER 0x4000
#endif

#ifndef WM_ICONIFY
#define WM_ICONIFY 34
#endif

#ifndef WM_UNICONIFY
#define WM_UNICONIFY 35
#endif

#ifndef WM_ALLICONIFY
#define WM_ALLICONIFY 36
#endif

#ifndef WM_BOTTOMED
#define WM_BOTTOMED 33
#endif

#ifndef WF_ICONIFY
#define WF_ICONIFY 26
#endif

#ifndef WF_UNICONIFY
#define WF_UNICONIFY 27
#endif

/* New constant for new message (i need it in order to handle properly color palettes) */
/* 700 est une valeur arbitraire non deja prise par un evenements AES */

#ifndef WM_RESTOREPAL
#define WM_RESTOREPAL 700 
#endif

static WORD restorepalmsg[8]={WM_RESTOREPAL};

void look_event(int);

/* -------------------------------------------------------------------- */
/*       Macros.                                                        */
/* -------------------------------------------------------------------- */

#define min(a, b)           ((a) < (b) ? (a) : (b))
#define max(a, b)           ((a) > (b) ? (a) : (b))
#define sgn(x) 				((x==0)?(0):((x<0)?(-1):(1)))
#define abs(x) 				((x<0)?(-(x)):(x))
 
/* -------------------------------------------------------------------- */
/*       Variables globales.                                            */
/* -------------------------------------------------------------------- */

static	int    whandle=0;                   /* Identificateur de la fentre     */
static	char   title[] = NOM_FENETRE;       /* Titre de la fentre              */
static	int    gl_wchar,                    /* Largeur et hauteur d'un          */
		       gl_hchar,                    /*   caractre                      */
		       gl_wbox,                     /* Largeur et hauteur de la         */
		       gl_hbox;                     /*   zone d'affichage               */

static	int    phys_handle=0,               /* Identificateur pour GEM et VDI   */
		       handle=0;
static	int    max_x,                       /* Largeur maximale de l'cran      */
		       max_y;                       /* Hauteur maximale de l'cran      */
static	int    appl_id,                     /* Identificateur du programme      */
		       menu_id;                     /* Identificateur dans le menu GEM  */


static int ungetched=0;

static int cur_y=0;
static int cur_x=0;

static int couleur_fond=BLANC;

static 	WORD  	b_handle[1],
				bitmap_out[128];
static 	MFDB	bitmap[1],
				screen;

static 	long	EdDI_present;
static  int		VDI_Enhancer_1_0=0;

static	jmp_buf	glcb_jmpb;

static 	int		ggsleep=0;
static	int 	topped=0;
static  int		acc_error=0;
static	int		iconified=0;

typedef struct
{	
	long 	ident;
	long	valeur;
}	t_cookie;



void event_loop( void );

static int again=0;
static int acc_ok=0;



static int desk=0;   
static unsigned int deskpalsize;
static unsigned int deskpal[256][3];

static unsigned int egapal[16]=
{
	0x8fff,0x0000,0x4f00,0x50f0,
	0x400f,0x60ff,0x7ff0,0x5f0f,
	0x5ccc,0x3888,0x2800,0x3080,
	0x1008,0x5088,0x4880,0x3808
};

static unsigned int oldpal[16]=
{
	0x8fff,0x0000,0x4f00,0x50f0,
	0x400f,0x60ff,0x7ff0,0x5f0f,
	0x5ccc,0x3888,0x2800,0x3080,
	0x1008,0x5088,0x4880,0x3808
};



static nocolor= -2;

static int oldmousek=0;

static int mousex,mousey,mousek,vblclock;
static int msex,msey,msek,mclk;

static int nbrbuffer=0;
static int lstbufptr=0;
static int msebufptr=0;
static int msebuffer[128];

char keymap[256]={
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};


static int keybuffer[256];
static int keybufptr=0;
static int keybufend=0;
static int keybufnbr=0;



/* souris du bureau : ne pas modifier */
static MFORM souris1={
			0,0,
			1,
			0,
			1,			
			0xc000,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xff00,0xff80,
			0xffc0,0xffe0,0xfe00,0xef00,0xcf00,0x8780,0x0780,0x0380,
			0x0000,0x4000,0x6000,0x7000,0x7800,0x7c00,0x7e00,0x7f00,
			0x7f80,0x7c00,0x6c00,0x4600,0x0600,0x0300,0x0300,0x0000
			};

#ifndef NO_CURSOR
/* souris du programme (mode monochrome) */
static MFORM souris2={
			0,0,
			1,
			1,
			0,	
			0xc000,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xff00,0xff80,
			0xffc0,0xffe0,0xfe00,0xef00,0xcf00,0x8780,0x0780,0x0380,
			0x0000,0x4000,0x6000,0x7000,0x7800,0x7c00,0x7e00,0x7f00,
			0x7f80,0x7c00,0x6c00,0x4600,0x0600,0x0300,0x0300,0x0000
			};

/* souris du programme (si palette systeme modifiee) */
static MFORM souris4={
			0,0,
			1,
			0,
			SYSTEM_CURSOR_COLOR,
			0xc000,0xe000,0xf000,0xf800,0xfc00,0xfe00,0xff00,0xff80,
			0xffc0,0xffe0,0xfe00,0xef00,0xcf00,0x8780,0x0780,0x0380,
			0x0000,0x4000,0x6000,0x7000,0x7800,0x7c00,0x7e00,0x7f00,
			0x7f80,0x7c00,0x6c00,0x4600,0x0600,0x0300,0x0300,0x0000
			};
#else
static MFORM souris2={
			0,0,
			1,
			0,
			1,			
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			};
static MFORM souris4={
			0,0,
			1,
			0,
			1,			
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			};
#endif



/* souris invisible */
static MFORM souris3={
			0,0,
			1,
			0,
			1,			
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
			};



#define MOUSE_OUTSIDE	0
#define MOUSE_INSIDE	1

int mouse_pos=MOUSE_OUTSIDE;


static	int window_x,window_y,window_w,window_h;
static	int menubar_x,menubar_y,menubar_w,menubar_h;
static  int window_y_min;

static int sommeil=0;

static int lastkey=0;

static char formstring[80];


static int 	ggfontwidth,ggfontheight;


static int pattern[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};




/*******************************************************************************/
/* Memoire virtuelle disponible */

unsigned long freevirtualram(void)
{
	return (unsigned long)gemdos(0x48,-1L);
}







/******************************************************************/
/* initialisation du systeme */

void savedeskpalette(void);
void restoredeskpalette(void);
void restorepalette(void);
int initsystem(void);
void killsystem(void);

static long gc(long target)
{
	long old_stack;
	t_cookie** ptr_tab_cookie=(t_cookie **)0x5a0;	/* pointeur vers le tableau	*/																				/* des cookie	*/
	t_cookie *tab_cookie;

	/* pour lire l'adresse du tableau des cookies, il faut etre en mode	
		superviseur		*/
	if (Super((void *)1L)==0L)	/* si on est en mode utilisateur	*/
	{		
		old_stack=Super(0L);	/* on passe en mode superviseur	*/
	}
	else
	{	
		old_stack=0;
	}
	tab_cookie=*ptr_tab_cookie;	/* on lit cette adresse			*/
	
	
	if (old_stack)				/* si on etait en utilisateur au debut	*/
	{
		Super((void *)old_stack);	/*  on y retourne */
	}				
		
	if (tab_cookie==0L)		/* si le tos <1.6, on n'a pas de cookie jar	*/
		return(-2);				
		
	do		/* on boucle jusqu'a avoir trouve le cookie ou avoir atteint			*/
			/* le dernier element de la cookie jar									*/
	{
		if (tab_cookie	->ident	==target)	/* si le cookie est le cookie recherch	*/
		{
			return(tab_cookie	->valeur);	/* on renvoie sa valeur					*/
		}
		else
		{
			/* sinon, on passe au cookie suivant	*/
			tab_cookie++;
		}	
	}	
	while (tab_cookie->ident!=0);	/* la table des cookie est toujours	*/
								/* terminee par un cookie dont l'ident vaut	0	*/

	/* si on n'a pas trouve le cookie	, on renvoie -1 */
	return(-1);
}


static void open_window( void )
{	
	int kind;
	int x,y,w,h;
	int x2,y2,w2,h2;

	w=WIDTH;
	h=HEIGHT;
	x=(max_x-w)/2;
	y=(max_y-h)/2;

	if ( whandle <= 0 )
	{			
		kind=NAME|CLOSER|MOVER|SMALLER;
		wind_calc(WC_BORDER,kind,x,y,w,h,&x2,&y2,&w2,&h2);
		whandle = wind_create( kind, 0, 0, max_x + 1, max_y + 1 );	
		if ( whandle <= 0 )	
			return;

		topped=1;
		sommeil=0;
		
		wind_set( whandle, WF_NAME, title );
		if (y2<window_y_min)
			y2=window_y_min;
		wind_open( whandle, x2, y2, w2, h2 );
	}
	else	
	{
		topped=1;
		sommeil=0;
		wind_set( whandle, WF_TOP );
	}

	mouse_pos=MOUSE_OUTSIDE;

	wind_get(whandle,WF_WORKXYWH,&window_x,&window_y,&window_w,&window_h);
	appl_write(appl_id,16,restorepalmsg);
}


static int rc_intersect( GRECT *r1, GRECT *r2 )
{	
	int x, y, w, h;
	
	x = max( r2->g_x, r1->g_x );
	y = max( r2->g_y, r1->g_y );
	w = min( r2->g_x + r2->g_w, r1->g_x + r1->g_w );
	h = min( r2->g_y + r2->g_h, r1->g_y + r1->g_h );
	
	r2->g_x = x;
	r2->g_y = y;
	r2->g_w = w - x;
	r2->g_h = h - y;
	
	return ( ((w > x) && (h > y) ) );
}




static void BitBlt(MFDB *dst, int xd, int yd, int wd, int hd,
				MFDB *src, int xs, int ys, int ws, int hs, int mode)
{
	WORD xyarr[8];

	xyarr[0] = xs;
	xyarr[1] = ys;
	xyarr[2] = xs+ws-1;
	xyarr[3] = ys+hs-1;
	xyarr[4] = xd;
	xyarr[5] = yd;
	xyarr[6] = xd+wd-1;
	xyarr[7] = yd+hd-1;
	if (handle)
		vro_cpyfm( handle, mode, xyarr, src, dst );
}






static void redraw_window( void )
{            
	int		t;
	GRECT	work,box;
	int		clip[4];
	
	if( whandle <= 0 )                 /* Il n'y a aucune fentre       */
		return;                          

     
	wind_update( BEG_UPDATE );

	graf_mouse( M_OFF, (void *)0 );
	
	wind_get( whandle, WF_WORKXYWH, &work.g_x, &work.g_y, &work.g_w, &work.g_h );
	work.g_w = min( work.g_w, max_x - work.g_x + 1 );
	work.g_h = min( work.g_h, max_y - work.g_y + 1 );

	wind_get( whandle, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h );
	while ( box.g_w > 0 && box.g_h > 0 )
	{	
		if( rc_intersect( &work, &box ) )
		{		
			clip[0] = box.g_x;
			clip[1] = box.g_y;
			clip[2] = box.g_x+box.g_w-1;
			clip[3] = box.g_y+box.g_h-1;
			
			vs_clip( handle, 1, clip );		
		
			screen.fd_addr = 0;
			if (!iconified)
				BitBlt(	&screen,work.g_x,work.g_y,work.g_w,work.g_h,
						&bitmap[0],0,0,WIDTH,HEIGHT,S_ONLY
						);
			else
			{
				t=nocolor;
				vsf_color( handle, 0 );                       /* set white fill   */
				vswr_mode( handle, 1 );                       /* set replace mode */
				v_bar( handle, clip);
				vsf_color( handle, 1 );
				v_gtext( handle, work.g_x+(work.g_w-gl_wchar*(int)strlen(NOM_ICONE))/2, work.g_y+work.g_h/2, NOM_ICONE);
				ggsetcolor(t);
			}
		}
		wind_get( whandle, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h );
	}
	
	graf_mouse( M_ON, (void *)0 );

	wind_update( END_UPDATE );

}


/*       Traitement des vnements reus dans le tampon  message.      */
/*       ->                      Pointeur sur le tampon  message.      */
/*       <-                      Si la fentre est referme et si le    */
/*                                 programme n'est pas un accessoire,   */
/*                                 alors la fonction retourne 1 pour    */
/*                                 signaler l'arrt du programme, sinon */
/*                                 la fonction retourne toujours 0.     */

static void handle_message( int pipe[8] )
{

	if ((acc_error)&&(pipe[0]!=AC_OPEN))
		return;
	
	switch ( pipe[0] )
	{	
		case WM_RESTOREPAL:	
			if (topped==1)
			{
				topped=2;
				sommeil=0;
				if (handle)
				{
					savedeskpalette();
					restorepalette();
				}
			}
			break;
	
		case WM_REDRAW:	
			redraw_window( );		
			break;
		
		case WM_ONTOP:
		case WM_TOPPED:		
			if (pipe[3]==whandle)
			{
				topped=1;
				sommeil=0;
				wind_set( whandle, WF_TOP );
				appl_write(appl_id,16,restorepalmsg);
			}
			break;			


		case WM_UNTOPPED:
			restoredeskpalette();
			topped=0;
			sommeil=0;
			break;
		
		
		case AP_TERM:
		case AP_RESCHG:
		case WM_CLOSED:
			if ( pipe[3] == whandle )
			{	
				restoredeskpalette();
				topped=0;
				sommeil=0;
				wind_close( whandle );
				wind_delete( whandle );
				whandle = 0;
				iconified=0;
			}
			
			if ( _app )	
			{
				killsystem();
			}
#ifdef KILLED_WHEN_CLOSED
			if (!ggsleep)
			{
				killsystem();
			}
#endif
			break;
		
		case WM_MOVED:
		case WM_SIZED:		
			if ( pipe[3] == whandle )
			{
				wind_set( whandle, WF_CURRXYWH,  pipe[4], pipe[5], pipe[6], pipe[7] );
				wind_get(whandle,WF_WORKXYWH,&window_x,&window_y,&window_w,&window_h);
				redraw_window( );			
			}
			break;
			
		case WM_BOTTOMED:
			if ( pipe[3] == whandle )		
			{	
				wind_set( whandle, WF_BOTTOM);
				restoredeskpalette();
				topped=0;
				sommeil=0;
			}
			break;
			
		case WM_ICONIFY:
		case WM_ALLICONIFY:
			if ( pipe[3] == whandle )		
			{	
				wind_set( whandle, WF_ICONIFY,  pipe[4], pipe[5], pipe[6], pipe[7] );
				iconified=1;
				restorepalette();
			}
			break;
			
		case WM_UNICONIFY:
			if ( pipe[3] == whandle )		
			{	
				wind_set( whandle, WF_UNICONIFY,  pipe[4], pipe[5], pipe[6], pipe[7] );
				wind_get(whandle,WF_WORKXYWH,&window_x,&window_y,&window_w,&window_h);
				savedeskpalette();
				iconified=0;
				restorepalette();
			}
			break;
			
		
		case AC_OPEN:
			if ( pipe[4] == menu_id )	
			{
				if (ggsleep)
				{
					ggsleep=0;
					longjmp(glcb_jmpb,0);
				}
				
				if (!acc_error)
					open_window( );
				else
				{
					switch(acc_error)
					{
						case 1:
							form_alert(1,"[3][|I need VDI Enhancer |or NVDI (>=2.5) |in order to work! |][Sorry]");
							break;
						case 2:
							form_alert(1,"[3][ |Can't create first |off-screen bitmap! |(Out of memory ?) | ][Sorry]");
							break;
						case 3:
							form_alert(1,"[3][Can't create second |off-screen bitmap! |(This version of NVDI bugs) |Use VDI Enhancer 1.0 or another |(patched) NVDI version ][Sorry]");
							break;
						case 4:
							form_alert(1,"[3][ |Sorry, but 'GEM_ACC.H' |must be included in order |to make a correct accessory! | ][Sorry]");
							break;
						case 5:
							sprintf(formstring,"[3][Sorry, but screen is |not large enough! | |Select a better resolution |(at least %dx%d) ][OK]",WIDTH,HEIGHT);
							form_alert(1,formstring);
							break;
						case 6:
							form_alert(1,"[3][ |Can't work with a |true color mode ! |Select another mode. | ][Sorry]");
							break;
					}
				}
			}
			break;
		
		case AC_CLOSE:	
			if ( pipe[3] == menu_id )	
			{
				if (EdDI_present!= -1)
				{
					if (!ggsleep)
					{
						killsystem();
					}
				}
					
			}
			break;
	}
}


			
static WORD	open_bitmap( WORD w, WORD h, MFDB *bitmap)
{
	WORD	count,
			dummy,
			handle,
			xyarr[4],
			bitmap_in[20];

	w=(w+15)&0xfff0;
		
	bitmap->fd_addr = 0;
	bitmap->fd_nplanes = 0;
			
	handle = graf_handle( &dummy, &dummy, &dummy, &dummy );

	for ( count = 1; count < 10; count++ )
		bitmap_in[count] = 1;

	bitmap_in[0] = Getrez()+2;
	bitmap_in[10] = 2;					
	bitmap_in[11] = w-1;
	bitmap_in[12] = h-1;
	bitmap_in[13] = bitmap_in[14] = 0;		
	
	for ( count = 15; count < 20; count++ )
		bitmap_in[count] = 0;				
	
	v_opnbm( bitmap_in, bitmap, &handle, bitmap_out );

	if (handle)	
	{
		xyarr[0] = 0;
		xyarr[1] = 0;
		xyarr[2] = bitmap_out[0];
		xyarr[3] = bitmap_out[1];
		vs_clip( handle, 1, xyarr );

		vst_alignment(handle,0,5,&dummy,&dummy);
	}

	return( handle );
}



			




static int initacc(void)
{
	acc_ok=1; /* setjmp a ete execute dans main() : ouf! */
	return initsystem();
}






static int initsystem( void )
{	
	int i;
	int work_in[11];
	int work_out[57];
	int pts[8];


	couleur_fond=BLANC;

	phys_handle=0;
	handle=0;
 	topped=0;
	iconified=0;
	
	nocolor= -2;

	ungetched=0;
	
	cur_x=0;
	cur_y=0;
	
	oldmousek=0;
	
	nbrbuffer=0;
	lstbufptr=0;
	msebufptr=0;
	
	keybufptr=0;
	keybufend=0;
	keybufnbr=0;


	if (!again)
	{
		appl_id = appl_init( );
		if ( appl_id == -1 )
			return 0;
	}

	
	for ( i = 0; i < 10; i++ )	
		work_in[i]  = 1;
	work_in[0] = Getrez()+2;
	work_in[10] = 2;
	phys_handle = graf_handle( &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox );

	ggfontwidth=gl_wchar;
	ggfontheight=gl_hchar;

	handle = phys_handle;
	v_opnvwk( work_in, &handle, work_out );
	if ( handle == 0 )	
	{	
		form_alert(1,"[3][ | |Can't open workstation ! | | ][Sorry]");
		appl_exit( );
		return 0;
	}

	deskpalsize=work_out[13];
	max_x = work_out[0]; 
	max_y = work_out[1];

	vqt_extent(phys_handle,"Query menubar height!",pts);
	menubar_x=0;
	menubar_y=0;
	menubar_w=max_x+1;
	menubar_h=(abs(pts[1]-pts[7])+4)*2; /* 100% de marge */
	window_y_min=abs(pts[1]-pts[7])+4;
		
	vq_extnd(handle,1,work_out);

	if (!work_out[5])
		deskpalsize=0;

	if ( ((1L<<((unsigned long)work_out[4]))!=(unsigned long)deskpalsize)
			|| (deskpalsize>256) )
	{
		if (_app)
		{
			form_alert(1,"[3][ |Can't work with a |true color mode ! |Select another mode. | ][Sorry]");
			appl_exit( );
			return 0;
		}
		else
		{
			v_clsvwk( handle );
			handle=0;
			acc_error=6;
			menu_id = menu_register( appl_id, NOM_ACC );
			event_loop();
		}
	}

	if ((emulmono)||(deskpalsize<16))
		modemono=1;			
			
	EdDI_present= gc('EdDI');

	if ((EdDI_present>0)&&(gc('NVDI')== -1))
	{
		modemono=1;
		VDI_Enhancer_1_0=1;
	}

	if ((WIDTH>max_x+1)||(HEIGHT>max_y+1))
		if (!_app)
		{
			acc_error=5; /* provoquer erreur, car l'ecran est trop petit !*/
			v_clsvwk( handle );
			handle=0;
			menu_id = menu_register( appl_id, NOM_ACC );
			event_loop();
		}
		else
		{
			sprintf(formstring,"[3][Sorry, but screen is |not large enough! | |Select a better resolution |(at least %dx%d) ][OK|Continue]",WIDTH,HEIGHT);
			if (form_alert(1,formstring)==1)
			{
				appl_exit( );
				return 0;
			}
		}
	
	if ((acc_ok==0)&&(!_app))
	{
		acc_error=4; /* provoquer erreur, car gem_acc.h n'a pas ete utilise !*/
		v_clsvwk( handle );
		handle=0;
		menu_id = menu_register( appl_id, NOM_ACC );
		event_loop();
	}

	if ( EdDI_present == -1 )	
	{	
		if (_app)
		{
			form_alert(1,"[3][ |I need VDI Enhancer |or NVDI (>=2.5) |in order to work! | ][Sorry]");
			appl_exit( );
			return 0;
		}
		else
		{
			v_clsvwk( handle );
			handle=0;
			acc_error=1;
			menu_id = menu_register( appl_id, NOM_ACC );
			event_loop();
		}
	}
	else
	{	
		if (!VDI_Enhancer_1_0)
			b_handle[0] = open_bitmap( WIDTH, HEIGHT, &bitmap[0]);
		else
		{
			/* all this, because of strange bug in VDI Enhancer 1.0 :
			   mouse is not allowed to exit rectangle(0,0,w,h) with
			   (w,h)=size of the off-screen bitmaps blted to screen ?!? */
		
			b_handle[0] = open_bitmap( max_x+1, max_y+1, &bitmap[0]);
			if (b_handle[0])	
			{
				pts[0] = 0;
 				pts[1] = 0;
				pts[2] = WIDTH-1;
				pts[3] = HEIGHT-1;
				vs_clip( b_handle[0], 1, pts );
			}
		}
		

		if (!b_handle[0])
		{
			if (!b_handle[0])
				if (_app)
					form_alert(1,"[3][ |Can't create first |off-screen bitmap! |(Out of memory ?) | ][Sorry]");
				else
					acc_error=2;

			if (b_handle[0])
				v_clsbm( b_handle[0] );
			v_clsvwk( handle );
			handle=0;
			if (_app)
			{
				appl_exit( );
				return 0;
			}
		}
	}

	if ((acc_error)&&(!_app))
	{
		menu_id = menu_register( appl_id, NOM_ACC );
		event_loop();
	}
				              /* Si le programme a t lanc en     */	
		                      /*   tant qu'accessoire _app vaut 0,  */
				              /*   sinon _app vaut 1                */	
	if ( !_app )
	{
		if (!again)
			menu_id = menu_register( appl_id, NOM_ACC );
		else
			if (!acc_error)
				open_window();
	}
	else
	{	
		graf_mouse( 0, (void*)0 );
		open_window( );
	}


	again=1;

	ggsetpalette(egapal);
	ggsetcolor(NOIR);
	
	ggcls();

	return 1;
}



static void killsystem(void)
{
	if (b_handle[0])
		v_clsbm( b_handle[0] );
	b_handle[0]=0;

	if (whandle>0)
	{
		restoredeskpalette();
		topped=0;
		sommeil=0;
		wind_close( whandle );
		wind_delete( whandle );
		iconified=0;
	}
	whandle = 0;
		
	if (handle)
	{
		v_clsvwk( handle );
		handle=0;
	}



	if (_app)
	{	
		appl_exit( );
		exit(0);
	}
	else
	{
		if (!acc_error)
			ggsleep=1;
		event_loop();
	}
}




int main(void)
{
	if (setjmp(glcb_jmpb)+initacc())
	{
		principal();
		killsystem();
	}
	return 0;
}









/***************************************************************/
/* simulation du mode texte */

int largeur_caractere(void)
{
	return ggfontwidth;
}

int hauteur_caractere(void)
{
	return ggfontheight;
}


void outtextxy(int x, int y, char *chaine)
{
	int i,len,t;
	char *null_string="<NULL>";
	char tmp[2];
	
	tmp[1]=0;

	if (!chaine)
		chaine=null_string;

	cur_x=x;
    cur_y=y;

    len=(int)strlen(chaine);

	for(i=0;i<len;i++)
	{
		switch(chaine[i])
		{
			case 27:
            case '\b':
				break;
			case '\n':
			case '\r':
				cur_x=0;
				cur_y+=ggfontheight;
				break;

			case '\t':
				if (couleur_fond==BLANC)
					v_gtext(b_handle[0],cur_x,cur_y," ");
				else
				{
					t=nocolor;
					ggpbox(cur_x,cur_y,ggfontwidth,ggfontheight,couleur_fond);
					ggsetcolor(t);
				}
				
				cur_x+=TABNBR*ggfontheight;
				cur_x=(cur_x/(TABNBR*ggfontheight))*TABNBR*ggfontheight;
				break;

           	default:
         		tmp[0]=chaine[i];
				if (couleur_fond!=BLANC)
				{
					t=nocolor;
					ggpbox(cur_x,cur_y,ggfontwidth,ggfontheight,couleur_fond);
					ggsetcolor(NOIR);
/*					vswr_mode(b_handle[0],MD_ERASE);
					v_gtext(b_handle[0],cur_x,cur_y,tmp);
*/					ggsetcolor(t);
					vswr_mode(b_handle[0],MD_TRANS);
					v_gtext(b_handle[0],cur_x,cur_y,tmp);
					vswr_mode(b_handle[0],0);
				}
				else
					v_gtext(b_handle[0],cur_x,cur_y,tmp);
				cur_x+=ggfontwidth;
		}

		if (cur_x+ggfontwidth>WIDTH)
		{
			cur_x=0;
            cur_y+=ggfontheight;
		}

        if (cur_y+ggfontheight>HEIGHT)
		{
			cur_y=0;
			getch();
			clrscr();
        }
	}
}


int wherex(void)
{
	return (cur_x/ggfontwidth)+1;
}

int wherey(void)
{
	return (cur_y/ggfontheight)+1;
}


void clrscr(void)
{
	ggcls();
	cur_x=0;
    cur_y=0;
}

void gotoxy(int x, int y)
{
	cur_x=(x-1)*ggfontwidth;
	cur_y=(y-1)*ggfontheight;
}

void clreol(void)
{
	int x,y;

	x=wherex();
	y=wherey();

	while(y==wherey())
		printf(" ");

	gotoxy(x,y);
}

int sputs(char *s)
{
	outtextxy(cur_x,cur_y,s);

    return 1;
}

int puts(const char *s)
{
	outtextxy(cur_x,cur_y,(char *)s);
	outtextxy(cur_x,cur_y,(char *)"\n");

    return 1;
}

char *gets(char *s)
{
	int n=0;
	int x,y;
	char touche;

	if (cur_y>HEIGHT-ggfontheight)
		clrscr();	

	s[0]=0;

	x=cur_x;
    y=cur_y;

    outtextxy(x,y,"_");
	ggrefresh();

	do
	{
		touche=getch();

		if (touche=='\b')
        {
			if (n)
			{
				s[n]=' ';
				s[n+1]=0;
				outtextxy(x,y,s);
				n--;
            }
        }
		else
           	if (touche!='\r')
				s[n++]=touche;

		s[n]='_';
		s[n+1]=' ';
        s[n+2]=' ';
		s[n+3]=0;

		outtextxy(x,y,s);
		ggrefresh();
	}
	while (touche!='\r');

	s[n]=' ';
	s[n+1]=' ';
	outtextxy(x,y,s);
	s[n]=0;

	outtextxy(cur_x,cur_y,"\n");

	return s;
}

int scanf(const char *format, ...)
{
	int r;
	char s[250];

	va_list ap;

	va_start(ap,format);

    gets(s);

	r=vsscanf(s,format,ap);

	va_end(ap);

    return r;
}
     
int vscanf(const char *format, va_list arglist)
{
	int r;     
	char s[250];

    gets(s);

	r=vsscanf(s,format,arglist);

    return r;
}

int printf(const char *format, ...)
{
	int r;     
	char s[250];

	va_list ap;

	va_start(ap,format);
	r=vsprintf(s,format,ap);

    sputs(s);

	va_end(ap);

    return r;
}

int vprintf(const char *format, va_list arglist)
{
	int r;     
	char s[250];

	r=vsprintf(s,format,arglist);

	sputs(s);

	return r;
}









/***************************************************************/
/* gestion des 16 couleurs */


void ggsetcolor(int c)
{
	static int couleur_courante=NOIR;
	static int couleur_precedente=NOIR;
    int f;

	if (c==COULEUR_PRECEDENTE)
	{
		c=couleur_precedente;
		couleur_precedente=couleur_courante;
		couleur_courante=c;
	}
	else
	{
		if (c!= -1)
        {
			couleur_precedente=couleur_courante;
            couleur_courante=c;
        }
	}


	if (nocolor!=c)
	{
		nocolor=c;

		c&=(~XOR_MODE);

		if (modemono)
		{
			f=oldpal[((unsigned int)c)&15]>>12;
			if (f<4)
				vst_color(b_handle[0],1);
			else
				vst_color(b_handle[0],0);
		}
		else
		{
			if (deskpalsize>=32)
				vst_color(b_handle[0],c+16);
			else
				vst_color(b_handle[0],c);
		}
				

		if (!modemono)
		{		
			if (deskpalsize>=32)
				c+=16;

			vsf_color( b_handle[0], c );
			vsf_interior( b_handle[0], 2 ); 
			vsf_style( b_handle[0], 8 );
			vsf_perimeter( b_handle[0], 1 );
			vswr_mode( b_handle[0], 0 );
		}
		else
		{
			f=oldpal[((unsigned int)c)&15]>>12;

			f=8-f;


			if ((!f)&&(VDI_Enhancer_1_0))
			{
				/* VDI_Enhancer_1_0 reacts strangely...
				   It doesn't accept color 0 & fill style 8 !?! */
				f=0;
				
				vsf_color( b_handle[0], 1 );
				vsf_interior( b_handle[0], 4 ); 
				vsf_udpat( b_handle[0], pattern, 1);
				vsf_perimeter( b_handle[0], 1 );
				vswr_mode( b_handle[0], 0 );
			}
			else
			if (f)
			{
				vsf_color( b_handle[0], 1 );
				vsf_interior( b_handle[0], 2 ); 
				vsf_style( b_handle[0], f );
				vsf_perimeter( b_handle[0], 1 );
				vswr_mode( b_handle[0], 0 );
			}
			else
			{
				vsf_color( b_handle[0], 0 );
				vsf_interior( b_handle[0], 2 ); 
				vsf_style( b_handle[0], 8 );
				vsf_perimeter( b_handle[0], 1 );
				vswr_mode( b_handle[0], 0 );
			}
		}	
			
		if (nocolor&XOR_MODE)
			vswr_mode(b_handle[0],MD_XOR);
		else
			vswr_mode(b_handle[0],0);
		
	}
}


void ggsetbkcolor(int c)
{
	static int couleur_fond_courante=NOIR;
	static int couleur_fond_precedente=NOIR;

	if (c==COULEUR_PRECEDENTE)
	{
		c=couleur_fond_precedente;
		couleur_fond_precedente=couleur_fond_courante;
		couleur_fond_courante=c;
	}
	else
	{
		if (c!= -1)
        {
			couleur_fond_precedente=couleur_fond_courante;
            couleur_fond_courante=c;
        }
	}

	if (c!= -1)
		couleur_fond=c;

}



void gggetpalette(unsigned int *pal)
{
	int i;

	for(i=0;i<16;i++) pal[i]=oldpal[i];
}


static void savedeskpalette(void)
{
	int i;
	
	if (!modemono)
	{
		for(i=0;i<deskpalsize;i++)
			vq_color(handle,i,1,(WORD *)deskpal[i]);
		desk=1;
	}
}


static void restoredeskpalette(void)
{
	int i;
	
	if ((!modemono)&&(desk)&&(topped==2)&&(!iconified))
	{
		for(i=0;i<deskpalsize;i++)
			vs_color(handle,i,(WORD *)deskpal[i]);
	}
	
	if (phys_handle)
		vsc_form(phys_handle,(int *)&souris1);
}


static void restorepalette(void)
{
	int i;
	unsigned int c[3];
	int offset=0;
	
	if (iconified)
	{
		if ((!modemono)&&(whandle>0)&&(topped==2))
			for(i=0;i<deskpalsize;i++)
				vs_color(handle,i,(WORD *)deskpal[i]);
	}
	else
	{
		if ((!modemono)&&(whandle>0)&&(topped==2))
		{
			if (deskpalsize>=32)
				offset=16;
			for(i=0;i<16;i++)
			{
				c[0]=((oldpal[i]>>8)&15)*66+10;
				c[1]=((oldpal[i]>>4)&15)*66+10;
				c[2]=(oldpal[i]&15)*66+10;
				vs_color(handle,i+offset,(WORD *)c);
			}
		}
	}

	if ((mouse_pos==MOUSE_INSIDE)&&(!iconified)&&(topped==2)&&(phys_handle))
	{
		if ((modemono)||(deskpalsize>=32))
			vsc_form(phys_handle,(int *)&souris2);
		else
			vsc_form(phys_handle,(int *)&souris4);
	}
}

void ggsetpalette(unsigned int *pal)
{
	int i;

	for(i=0;i<16;i++) oldpal[i]=pal[i];
	restorepalette();	
}









/************************************************************/
/* instructions de gestion des ecrans graphiques */



void ggsimplescreen(void)
{
}


void ggdoublescreen(void)
{
}


void ggcls(void)
{
	int t;

	t=nocolor;
	ggpbox(0,0,WIDTH,HEIGHT,couleur_fond);
	ggsetcolor(t);
}



void ggrefresh(void)
{
	vblclock++;

	redraw_window();
	look_event(0); 
}



void ggswap(void)
{                                    
	vblclock++;

	redraw_window();
	look_event(0);                   
}












/******************************************************************/
/* instructions graphiques de base */


void ggpellipse(int x,int y,int lx,int ly,int c)
{
	if (c>=0) ggsetcolor(c);

	v_ellipse( b_handle[0], x+(lx)/2, y+(ly)/2, (lx)/2, (ly)/2 );
}

void ggellipse(int x,int y,int lx,int ly,int c)
{
	int xy[33][2];
	int i;
	double pas_angulaire=2*3.1416/32;
	double angle=0.0;
	
	if (c>=0) ggsetcolor(c);

	for(i=0;i<33;i++)
	{
		xy[i][0]=x+lx/2+(int)((lx/2)*cos(angle));
		xy[i][1]=y+ly/2+(int)((ly/2)*sin(angle));
		angle+=pas_angulaire;
	}

	ggpolyline(33,(int *)xy,-1);
}


void ggpbox(int x,int y,int lx,int ly,int c)
{
	int	r[4];

	if (c>=0) ggsetcolor(c);

	r[0] = x;
	r[1] = y;
	r[2] = (x+lx)-1;
	r[3] = (y+ly)-1;
			
	vr_recfl( b_handle[0], r );
}

void ggplot(int x,int y,int c)
{
	int	r[4];

	if (c>=0) ggsetcolor(c);

	r[0] = x;
	r[1] = y;
	r[2] = (x+1)-1;
	r[3] = (y+1)-1;
			
	vr_recfl( b_handle[0], r );
}


void ggline(int x1,int y1,int x2,int y2,int c)
{
	int t[4];
	
	t[0]=x1;
	t[1]=y1;
	t[2]=x2;
	t[3]=y2;
	ggpolyfill(3,t,c);
}



void ggdbox(int x,int y,int lx,int ly,int c)
{
	if (c>=0) ggsetcolor(c);
	ggpbox(x,y,lx,1,-1);
	ggpbox(x,y+ly-1,lx,1,-1);
	ggpbox(x,y,1,ly,-1);
	ggpbox(x+lx-1,y,1,ly,-1);
}


void ggpolyline(int n,int *tp,int c)
{
	int i;

	if (c>=0) ggsetcolor(c);
	for(i=0;i<n-1;i++) ggline(tp[i*2],tp[i*2+1],tp[i*2+2],tp[i*2+3],-1);
}


void ggpolyfill(int n,int *tp,int c)
{
	if (c>=0) ggsetcolor(c);

	v_fillarea(b_handle[0],n-1,tp);	
}










/*************************************************************/
/* gestion de la souris et du clavier */


int souris(int *x, int *y, int *b)
{
	int r;

	r=gggetmouse();

	if (r)
	{
        	if (x)
			*x=msex;
                if (y)
			*y=msey;
                if (b)
			*b=msek;
	}
	else
	{		
        	if (x)
			*x=mousex;
                if (y)
			*y=mousey;
                if (b)
			*b=mousek;
	}

        return r;
}



static void addchar(int c)
{
	keymap[lastkey]=0;
	if (c!=lastkey)
	{
		lastkey=c;
		keymap[c]=1;
	}
	else
		lastkey=0;
	
	if (keybufnbr<256)
	{
		keybuffer[keybufptr++]=c;
		keybufnbr++;
		keybufptr&=255;
	}
}


static void addbut(int k,int x,int y,int c)
{
	int ptr;

	if (nbrbuffer<32)
	{
		ptr=(msebufptr>>1);
		msebuffer[ptr]=k;
		msebuffer[ptr+1]=x;
		msebuffer[ptr+2]=y;
		msebuffer[ptr+3]=c;
		msebufptr+=8;
		msebufptr&=255;
		nbrbuffer++;
	}
}


static void msemoved(int x,int y,unsigned int k)
{
	mousex=x;
	mousey=y;
	if (mousex<0) mousex=0;
	if (mousey<0) mousey=0;
	if (mousex>(WIDTH-1)) mousex=(WIDTH-1);
	if (mousey>(HEIGHT-1)) mousey=(HEIGHT-1);
	mousek=k;
}


void look_event(int mode)
{
	int x, y,		
		kstate,
		key,
		clicks,
		event,
		state;
	int pipe[8];
	int r;	

	if ((whandle<=0)||(topped!=2)||(iconified))
	{	
		if (!sommeil)	
		{
			if ((mode==1)||(mode==2)||(iconified))
				event = evnt_multi( MU_MESAG | MU_KEYBD,
				                  0,0,0,
				                  0,0,0,0,0,
				                  0,0,0,0,0,
				                  pipe,
				                  0, 0,
				                  &x, &y, &state, &kstate, &key, &clicks );
			else
				event = evnt_multi( MU_MESAG | MU_TIMER | MU_KEYBD,
								  0,0,0,
				                  0,0,0,0,0,
				                  0,0,0,0,0,
				                  pipe,
				                  1, 0,
				                  &x, &y, &state, &kstate, &key, &clicks );
		}
		else
		{
			if ((mode==1)||(mode==2))
				event = evnt_multi( MU_MESAG | MU_BUTTON | MU_KEYBD,
				                  1,1,(mousek^1)&1,
				                  0,0,0,0,0,
				                  0,0,0,0,0,
				                  pipe,
				                  0, 0,
				                  &x, &y, &state, &kstate, &key, &clicks );
			else
				event = evnt_multi( MU_MESAG | MU_TIMER | MU_BUTTON | MU_KEYBD,
				                  1,1,(mousek^1)&1,
				                  0,0,0,0,0,
				                  0,0,0,0,0,
				                  pipe,
				                  1, 0,
				                  &x, &y, &state, &kstate, &key, &clicks );
			
			if (event&MU_BUTTON)
			{
				mousek=state;
				
				if (!(mousek&1))
				{
					sommeil=0;
					topped=2;
					restorepalette();
				}
			}
		}		
				
		if (event&MU_MESAG )			
			handle_message( pipe );
	
		return;
	}
	

	switch(mode)
	{
		case 1:	
			event = evnt_multi( MU_KEYBD | MU_M1 | MU_M2 | MU_MESAG,
			                  0, 0, 0,
			                  mouse_pos, window_x, window_y, window_w, window_h,
		    	              0, menubar_x, menubar_y, menubar_w, menubar_h,
		        	          pipe,
		            	      0, 0,
		                	  &x, &y, &state, &kstate, &key, &clicks );
			break;
		case 2:	
			event = evnt_multi( MU_KEYBD | MU_BUTTON | MU_M1 | MU_M2 | MU_MESAG,
			                  1, 1, (mousek^1)&1,
			                  mouse_pos, window_x, window_y, window_w, window_h,
		    	              0, menubar_x, menubar_y, menubar_w, menubar_h,
		        	          pipe,
		            	      0, 0,
		                	  &x, &y, &state, &kstate, &key, &clicks );
			break;
		case 0:
		default:
			if (mouse_pos==MOUSE_INSIDE)
				event = evnt_multi( MU_KEYBD | MU_M1 | MU_M2 | MU_MESAG,
				                  0, 0, 0,
				                  0, window_x, window_y, window_w, window_h,
		    		              1, window_x, window_y, window_w, window_h,
		        		          pipe,
		            		      0, 0,
		                		  &x, &y, &state, &kstate, &key, &clicks );
			else
				event = evnt_multi( MU_KEYBD | MU_M1 | MU_M2 | MU_MESAG | MU_TIMER,
				                  0, 0, 0,
				                  0, window_x, window_y, window_w, window_h,
			    	              0, menubar_x, menubar_y, menubar_w, menubar_h,
		        		          pipe,
		            		      1, 0,
		                		  &x, &y, &state, &kstate, &key, &clicks );
	}


	if ((y<menubar_h)&&(!modemono))
	{
		restoredeskpalette();
		topped=0;
		sommeil=1;
	}


	if (event&(MU_M1|MU_BUTTON))
		msemoved(x-window_x,y-window_y,state);
	else
		msemoved(x-window_x,y-window_y,mousek);

	if ((topped)&&(event&MU_KEYBD))
	{
		if ((key==0x1e11)&&(kstate&4))
		{
#ifdef CTRL_Q_CONFIRM
			restoredeskpalette();
			r=form_alert(2,"[0][ | |Do you want to quit ? | | ][Yes|No]");
			restorepalette();
			if (r==1)
#endif		
			{
				killsystem();
			}
		}
		else
		{		
			if ((key&255)==0)
			{
				r=0x8000+((key>>8)&255);
				if (kstate&1) r|=0x4000;
				if (kstate&2) r|=0x4000;
				if (kstate&4) r|=0x2000;
				if (kstate&8) r|=0x1000;
				addchar(r);
			}
			else
				addchar(key&255);
		}
	}
	
	

	if ((topped)&&(event&MU_M2))
	{
		if ((mode==1)||(mode==2)||(mouse_pos==MOUSE_OUTSIDE))
		{
			if (!modemono)
			{
				restoredeskpalette();
				topped=0;
				sommeil=1;
			}
		}
		else
		{
			if (mouse_pos==MOUSE_INSIDE)
			{
				mouse_pos=MOUSE_OUTSIDE;
				if (phys_handle)
					vsc_form(phys_handle,(int *)&souris1);
			}
		}
	}

	if (topped)
	if (event&MU_M1)
	{
		if (mouse_pos==MOUSE_OUTSIDE)
		{			
			mouse_pos=MOUSE_INSIDE;
			if (phys_handle)
			{
				if ((modemono)||(deskpalsize>=32))
					vsc_form(phys_handle,(int *)&souris2);
				else
					vsc_form(phys_handle,(int *)&souris4);
			}
		}
		else
			if ((mode==1)||(mode==2))
				if (mouse_pos==MOUSE_INSIDE)
				{
					mouse_pos=MOUSE_OUTSIDE;
					if (phys_handle)
						vsc_form(phys_handle,(int *)&souris1);
				}

	}
	
	if (topped)
	if (mouse_pos==MOUSE_INSIDE)
	{
		if ((oldmousek&2)!=(mousek&2))
		{
			if (oldmousek&2)
				addbut(6,mousex,mousey,vblclock);
			else
				addbut(2,mousex,mousey,vblclock);
		}
		
		if ((oldmousek&1)!=(mousek&1))
		{
			if (oldmousek&1)
				addbut(5,mousex,mousey,vblclock);
			else
				addbut(1,mousex,mousey,vblclock);
		}			
		
		oldmousek=mousek;
	}
	


	if (event&MU_MESAG )			
		handle_message( pipe );

}

void event_loop( void )
{	
	while (1) look_event(0);
}

int kbhit(void)
{
	if (!keybufnbr)
		look_event(0);
	return(keybufnbr);
}

int ggbuthit(void)
{
	if (!nbrbuffer)
		look_event(0);
	return(nbrbuffer);
}

int ggkeyhit(void)
{
	if (!(keybufnbr|nbrbuffer))
		look_event(0);
	return(keybufnbr|nbrbuffer);
}


int ungetch(int c)
{
	if (ungetched)
		return EOF;
	else
		ungetched=c;
	return c;
}

int putch(int c)
{
	printf("%c",c);
	return c;
}




int getch(void)
{
	int c;

	ggrefresh();

	if (ungetched)
	{
       	c=ungetched;
		ungetched=0;
		return c;
    }


	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;
		if (c&0x8000)
			c=getch();
		return c;
	}

	do look_event(1); while(!keybufnbr);

	c=keybuffer[keybufend++];
	keybufend&=255;
	keybufnbr--;

	if (c&0x8000)
		c=getch();
	
	return c;
}



int sgetch(void)
{
	int c;

	if (ungetched)
	{
       	c=ungetched;
		ungetched=0;
		return c;
    }


	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;
		return c;
	}

	do look_event(1); while(!keybufnbr);

	c=keybuffer[keybufend++];
	keybufend&=255;
	keybufnbr--;
	
	return c;
}



int getche(void)
{
	int c;

	ggrefresh();

	if (ungetched)
	{
       	c=ungetched;
		ungetched=0;
	    printf("%c",c&255);
		return c;
    }


	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;

		if (c&0x8000)
			c=getch();
				
	    printf("%c",c);
		return c;
	}

	do look_event(1); while(!keybufnbr);

	c=keybuffer[keybufend++];
	keybufend&=255;
	keybufnbr--;

	if (c&0x8000)
		c=getch();

    printf("%c",c);
	
	return c;
}



int sgetche(void)
{
	int c;

	if (ungetched)
	{
       	c=ungetched;
		ungetched=0;
        printf("%c",c&255);
		return c;
    }


	if (keybufnbr)
	{
		c=keybuffer[keybufend++];
		keybufend&=255;
		keybufnbr--;
	    printf("%c",c);
		return c;
	}

	do look_event(1); while(!keybufnbr);

	c=keybuffer[keybufend++];
	keybufend&=255;
	keybufnbr--;	
    printf("%c",c);
        
	return c;
}




void ggempty(void)
{
	keybufnbr=keybufptr=keybufend=0;
	nbrbuffer=lstbufptr=msebufptr=0;
}


void ggconfirm(void)
{
	ggempty();
	do look_event(2); while (!nbrbuffer);
}

int gggetmouse(void)
{
	int ptr;

	if (ggbuthit())
	{
		ptr=(lstbufptr>>1);
		msek=msebuffer[ptr];
		msex=msebuffer[ptr+1];
		msey=msebuffer[ptr+2];
		mclk=msebuffer[ptr+3];
		lstbufptr+=8;
		lstbufptr&=255;
		nbrbuffer-=1;

/* msek: bit 0:bouton gauche bit 1:bouton droit bit 2:0:presse 1:relache */

		return msek;
	}

	return 0;
}



