/* 
	TEST PROGRAM FOR DU_LIB
	1994, Data Uncertain Software.
	Written by Craig Graham.
*/

#include <dulib.h>
#include "test.h"

/* Define some codes for events - these are arbitary integer values */

#define mev_QUIT		102
#define mev_BUTTON1		103
#define mev_SELTEXT		104
#define mev_OPENDIAL	105

/*
	This is going to be a callback function triggered by button 2.
	Note that callback functions are all "short nnnn(void)".
*/

short spam(void)
{
	form_alert(1,"[1][ SPAM!!!!!! | (button 2) | ][ spam? ]");
	return 0;
}

/*
	This is going to be a custom redraw function.
	Note that as with callbacks, redraw functions are all "short nnnn(void)".
	A redraw should simply draw it's object - the DU_LIB will handle walking
	the rectangle list & setting minimal clip rectangles.
*/
short redy()
{
	short x,y,rx,ry;

	rx=(cr_clip.g_w/2)-4;	/* GRECT cr_clip contains the dimensions of the obejct we are going to redraw */
	x=cr_clip.g_x+rx+2;
	ry=(cr_clip.g_h/2)-4;
	y=cr_clip.g_y+ry+2;
	
	v_ellipse(x_handle,x,y,rx,ry);	/* x_handle is a vdi screen workstation handle which we can use */
									/*  - this workstation was opened by enviroment_initialise();*/
	return 0;
}

short main(void)
{
	event e;
	char *t[20];
	char b[200];
	
/* Setup an array of char*'s - these will be the entries in the scroll list */
	t[0]="This is a demo of the";
	t[1]="DU_LIB GUI library for";
	t[2]="Lattice C.";
	t[3]="----------------------";
	t[4]="Written:[13/10/94]";
	t[5]="By: Craig Graham";
	t[6]="----------------------";
	t[7]="DULIB was written to";
	t[8]="provide a GUI for the";
	t[9]="other Data Uncertain ";
	t[10]="products.";

/* We always call the enviroment initialise function first - this will do all the appl_init() stuff */
   
	enviroment_initialise();

/* Load in the resource file */
	rsrc_load("TEST.RSC");

/* First, lets use the easy way to change text in a dialog */
	set_dialog_text(my_dial, TestText, "Testing DULIB Library");

/* Setup some events */
	Set_object_event(my_menu, MenuQuit, mev_QUIT);
	Set_object_event(my_menu, MenuOpenDialog, mev_OPENDIAL);
	Set_object_event(my_dial, Button1, mev_BUTTON1);

/* Setup a callback function */
	Set_object_callback(my_dial, Button2, &spam);

/* Setup a test custom redraw function - usually you attach these to a box to get something in the box*/
	Set_object_redraw(my_dial, CRbox, &redy);

/* Initialise the scrolling list object */
	Set_scroll_list(my_dial, ScrollList, mev_SELTEXT, t, 11, 4); /* event code = mev_SELTEXT, text from t, number of items in list=11, number of items to display=4*/

/* Set a few icon popups up */
	Set_icon_popup(my_dial, Popup1, GateIconPopup);
	Set_icon_popup(my_dial, Popup2, GateIconPopup);

/* Put out menu bar in */
	install_menu(my_menu);
	
/* Open a dialog */
	activate_dialog(my_dial,"DULIB TEST DIALOG",DIAL_ROLLUP);

	do
	{
		e=WaitEvent();			/* The all important call. This replaces event_multi */

		switch (e)
		{
			case mev_SELTEXT:
				strcpy(b,"[1][ SCROLL TEXT SELECTED : |");
				strcat(b,t[scroll_selection]);
				strcat(b,"| ][ OK ]");
				form_alert(1,b);
				break;
			case mev_OPENDIAL:
				activate_dialog(my_dial,"DULIB TEST DIALOG",DIAL_ROLLUP);
				break;
			case mev_BUTTON1:
				form_alert(1,"[1][ BUTTON 1 SELECTED ][ OK ]");
				break;
		}

	} while (e!=mev_QUIT);

	rsrc_free();

	close_down();

	return 0;
	
}
