/* 
  DU_LIB v2 
  Gem Window Management & Dialog Library For Lattice C 
  1994, by Craig Graham. 
 
  Based on the DU_LIBv1 Library for HiSoft Basic. 
*/
 
/* 
   GEM AES message handler 
*/
 
#include "dulib.h"

event process_message(short mb[]) 
{ 
	short m,x,y,w,h; 
	short e_wind; 
	OBJECT *a_l; 
	short sx,sy,sw,sh; 
	short a,b; 
	CallBack custom_handler; 
	event ret_v; 
	Wtype t;

	ret_v=0; 
	a_l=0;
 
 	e_wind=mb[3];	/*Window for which the message arrived*/ 
	m=mb[0];		/*Message type*/ 

	if (!xacc_message(mb))
	{
		if (m==MN_SELECTED)		/*Event was a menu*/ 
		{ 
			rsrc_gaddr(0,menu,&a_l); 
			custom_handler=Get_object_callback(menu, mb[4]);	/*Check for a custom object handler*/ 
			if (!custom_handler) 
			{ 
				ret_v=Get_object_event(menu,mb[4]);	/*Return menu item selected*/ 
				menu_tnormal(a_l,e_wind,1); 
			}else{
				this_dialog=menu; this_ob=mb[4];
				(*custom_handler)();               	/*Call a custom handler for that selection*/ 
				menu_tnormal(a_l,e_wind,1); 
			}
		} else { 
			switch(m)								/*Common messages for all window types*/
			{
													/*Xacc2 support*/
				case ACC_TEXT:						/*Recieve Text*/
					if (XaccTextHandler)
					{
						if ((*XaccTextHandler)())
						{
							xacc_ack( mb[1], TRUE );
						}else{
							xacc_ack( mb[1], FALSE );
						}
					}else{
						xacc_ack( mb[1], FALSE );
					}
					break;
				case WM_CLOSED: 
					close_dialog(e_wind);
					break; 
				case WM_TOPPED: 
					wind_get(e_wind,WF_TOP,&a,0,0,0);
					if (a==e_wind) 
					{ 
						wind_set(e_wind,WF_BOTTOM,0,0,0,0); 
					} else { 
						wind_set(e_wind,WF_TOP,0,0,0,0); 
					} 
					ret_v=3;
					break; 
				case WM_BOTTOMED: 
					wind_set(e_wind,WF_BOTTOM,0,0,0,0); 
					break; 
				case WM_UNTOPPED: 
					break; 
				case WM_REDRAW: 
					udx=mb[4]; udy=mb[5]; 
					udw=mb[6]; udh=mb[7]; 
					redraw_window(e_wind); 
					break;
				case WM_CUSTOM_REDRAW: 
					udx=mb[4]; udy=mb[5]; 
					udw=mb[6]; udh=mb[7]; 
					custom_redraw_window(e_wind); 
					break;
				case WM_HSLID:
					wind_set(e_wind,WF_HSLIDE,mb[4],0,0,0);
					if (windows[e_wind].redraw_mode==wrm_window)
					{
						if (windows[e_wind].window_type==wt_drawing)
						{
							custom_update_window(e_wind);
						}else{
							update_window(e_wind);
						}
					}
					break;
				case WM_VSLID:
					wind_set(e_wind,WF_VSLIDE,mb[4],0,0,0);
					if (windows[e_wind].redraw_mode==wrm_window)
					{
						if (windows[e_wind].window_type==wt_drawing)
						{
							custom_update_window(e_wind);
						}else{
							update_window(e_wind);
						}
					}
					break;

			}
		
			t=windows[e_wind].window_type;			/* Type of window we are looking at */ 
			switch(t)
			{
				case wt_dialog:
					switch(m)
					{
						case WM_FULLED:						/*With Dialog Windows, make them Roll-Ups*/ 
							wind_get(e_wind,WF_CURRXYWH,&sx,&sy,&sw,&sh); 
							wind_calc(1,15,sx,sy,sw,sh,&sx,&sy,&sw,&sh); 
							if (sh!=0) 
							{
								wind_calc(0,15,sx,sy,sw,0,&sx,&sy,&sw,&sh); 
							} else { 
 								rsrc_gaddr(0,windows[e_wind].the_dialog,&a_l); 
								form_center(a_l,&a,&b,&sw,&sh); 
								wind_calc(0,15,sx,sy,sw,sh,&sx,&sy,&sw,&sh); 
							} 
 							wind_set(e_wind,WF_CURRXYWH,sx,sy,sw,sh);
			    	    	break; 
						case WM_MOVED: 
							if (mb[4]<0) { mb[4]=0; } 
							wind_set(e_wind,WF_CURRXYWH,mb[4],mb[5],mb[6],mb[7]); 
							rsrc_gaddr(0,windows[e_wind].the_dialog,&a_l); 
							wind_get(e_wind,WF_WORKXYWH,&x,&y,&w,&h); 
							if (h!=0)
							{ 
								a_l->ob_x=x; 
								a_l->ob_y=y; 
							} 
							break; 
					}
					break;
				case wt_drawing:
					switch(m)
					{
						case WM_FULLED:						/*With Dialog Windows, make them Roll-Ups*/ 
							wind_get(e_wind,WF_PREVXYWH,&sx,&sy,&sw,&sh); 
 							wind_set(e_wind,WF_CURRXYWH,sx,sy,sw,sh);
 							rsrc_gaddr(0,windows[e_wind].the_dialog,&a_l); 
							wind_get(e_wind,WF_WORKXYWH,&x,&y,&w,&h);
							if (h!=0)
							{
								a_l->ob_x=x; 
								a_l->ob_y=y;
							}
	       			    	break; 
						case WM_MOVED:
							if (mb[4]<0) { mb[4]=0; } 
							wind_set(e_wind,WF_CURRXYWH,mb[4],mb[5],mb[6],mb[7]); 
							rsrc_gaddr(0,windows[e_wind].the_dialog,&a_l); 
							wind_get(e_wind,WF_WORKXYWH,&x,&y,&w,&h); 
							if (h!=0)
							{ 
								a_l->ob_x=x; 
								a_l->ob_y=y; 
							} 
							break; 
						case WM_SIZED:
							if (mb[4]<0) { mb[4]=0; } 
							wind_set(e_wind,WF_CURRXYWH,mb[4],mb[5],mb[6],mb[7]); 
							rsrc_gaddr(0,windows[e_wind].the_dialog,&a_l);
							wind_get(e_wind,WF_WORKXYWH,&x,&y,&w,&h);
							if (h!=0)
							{
								a_l->ob_x=x; 
								a_l->ob_y=y; 
							} 
							break; 
					}
					break;
			}
		}
	}
	return ret_v; 
}
 
int redraw_window(short wind_handle) 
{
	short t;
 
	t=windows[wind_handle].window_type;
 
 	wind_update(BEG_UPDATE); 
	switch (t) 
	{ 
		case wt_dialog: 
			display_dial(wind_handle); 
			break; 
		case wt_null: 
			display_dial(wind_handle); 
			break; 
		case wt_drawing:
			display_dial(wind_handle); 
			break; 
		case wt_static_menu:
			display_dial(wind_handle); 
			break; 
	} 
	wind_update(END_UPDATE);
 
	udx=udy=udw=udh=0 ;
	return 0;
}

int custom_redraw_window(short wind_handle) 
{
	short t;
 
	t=windows[wind_handle].window_type;
 
 	wind_update(BEG_UPDATE); 
	switch (t) 
	{ 
		case wt_dialog: 
			custom_display_dial(wind_handle); 
			break; 
		case wt_null: 
			custom_display_dial(wind_handle); 
			break; 
		case wt_drawing:
			custom_display_dial(wind_handle); 
			break; 
		case wt_static_menu:
			custom_display_dial(wind_handle); 
			break; 
	} 
	wind_update(END_UPDATE);
 
	udx=udy=udw=udh=0 ;
	return 0;
}
