/*
  DU_LIB v2
  Gem Window Management & Dialog Library For Lattice C
  1994, by Craig Graham.
  
  Based on the DU_LIBv1 Library for HiSoft Basic.
*/

/*
  AES Messaging Routines
*/

#include "dulib.h"


/* Update a window by sending ourselves a WM_REDRAW message via GEM.*/
int update_window(short wind_handle)
{
	short p;
	short x,y,w,h;
	
	for(p=0; p<9; messB[p++]=0);
	
	messB[0]=WM_REDRAW;
	messB[3]=wind_handle;

	wind_get(wind_handle,WF_CURRXYWH,&x,&y,&w,&h);
	messB[4]=x; messB[5]=y;
	messB[6]=w; messB[7]=h;
	
	return appl_write(AESid,16,messB);
}

/* Send ourselves a control message via GEM.*/
int I_send_message(short wind_handle, short msg)
{
	short p;
	
	for(p=0; p<9; messB[p++]=0);

	messB[0]=msg;
	messB[3]=wind_handle;
	return appl_write(AESid,16,messB);
}

/*Send redraw messages to all our windows for the area (sx,sy,sw,sh)*/
int send_redraw(short sx, short sy,short sw,short sh)
{
	short m,ha;
					
	for(ha=0; ha<9; messB[ha++]=0);
	messB[0]=WM_REDRAW;

	messB[4]=sx;messB[5]=sy;
	messB[6]=sw+5;messB[7]=sh+5;
	
	for(m=0; m<max_windows; m++)					/*Send redraw messages to all our other windows*/
	{
		if (windows[m].window_type!=wt_null)
		{
			messB[3]=m;
			appl_write(AESid,16,messB);
		}
	}
	return 0;
}

int custom_update_window(short wind_handle)
{
	short p;
	short x,y,w,h;
	
	for(p=0; p<9; messB[p++]=0);
	
	messB[0]=WM_CUSTOM_REDRAW;
	messB[3]=wind_handle;

	wind_get(wind_handle,WF_CURRXYWH,&x,&y,&w,&h);
	messB[4]=x; messB[5]=y;
	messB[6]=w; messB[7]=h;
	
	return appl_write(AESid,16,messB);
}

/* XACC2 support */

/* Set a callback routine to handle any ACC_TEXT messages */

short Set_XaccTextHandler(CallBack c)
{
	XaccTextHandler=c;
	return 1;
}
