/*
  DU_LIB v2
  Gem Window Management & Dialog Library For Lattice C
  1994, by Craig Graham.
  
  Based on the DU_LIBv1 Library for HiSoft Basic.
*/

/*
  Event & object handling
*/

#include "dulib.h"

event Get_object_event(short dialog, short ob)
{
	Elist *e;

	e=(Elist*)0;

	if (find_event(dialog,ob,&e))
	{
		return e->this_event;
	}else{
		return 0;
	}
}

short Set_object_event(short dialog, short ob, event e)
{
	Elist *n;
	n=(Elist*)0;

	if (!find_event(dialog,ob,&n))
	{
		n=(Elist*)malloc(sizeof(Elist));
		n->object=ob;
		n->next=event_value[dialog];
		event_value[dialog]=n;
		n->callback=(CallBack)0;
		n->dcallback=NULL;
		n->redraw=(CallBack)0;
		n->this_devent=0;
		n->stext.texts=NULL;
	}

	n->this_event=e;

	return 0;
}

event Get_object_devent(short dialog, short ob)
{
	Elist *e;

	e=(Elist*)0;

	if (find_event(dialog,ob,&e))
	{
		return e->this_devent;
	}else{
		return 0;
	}
}

short Set_object_devent(short dialog, short ob, event e)
{
	Elist *n;
	n=(Elist*)0;

	if (!find_event(dialog,ob,&n))
	{
		n=(Elist*)malloc(sizeof(Elist));
		n->object=ob;
		n->next=event_value[dialog];
		event_value[dialog]=n;
		n->callback=(CallBack)0;
		n->dcallback=NULL;
		n->redraw=(CallBack)0;
		n->this_event=0;
		n->stext.texts=NULL;
	}

	n->this_devent=e;

	return 0;
}

CallBack Get_object_callback(short dialog, short ob)
{
	Elist *e;
	e=(Elist*)0;

	if (find_event(dialog,ob,&e))
	{
		return e->callback;
	}else{
		return 0;
	}
}

short Set_object_callback(short dialog, short ob, CallBack c)
{
	Elist *n;
	n=(Elist*)0;
	
	if (!find_event(dialog,ob,&n))
	{
		n=(Elist*)malloc(sizeof(Elist));
		n->object=ob;
		n->next=event_value[dialog];
		event_value[dialog]=n;
		n->this_event=0;
		n->this_devent=0;
		n->dcallback=NULL;
		n->redraw=(CallBack)0;
		n->stext.texts=NULL;
		n->dcallback=NULL;
	}

	n->callback=c;
	
	return 0;
}

CallBack Get_object_dcallback(short dialog, short ob)
{
	Elist *e;
	e=(Elist*)0;

	if (find_event(dialog,ob,&e))
	{
		return e->dcallback;
	}else{
		return 0;
	}
}

short Set_object_dcallback(short dialog, short ob, CallBack c)
{
	Elist *n;
	n=(Elist*)0;
	
	if (!find_event(dialog,ob,&n))
	{
		n=(Elist*)malloc(sizeof(Elist));
		n->object=ob;
		n->next=event_value[dialog];
		event_value[dialog]=n;
		n->this_event=0;
		n->this_devent=0;
		n->callback=NULL;
		n->redraw=(CallBack)0;
		n->stext.texts=NULL;
	}

	n->dcallback=c;
	
	return 0;
}

CallBack Get_object_redraw(short dialog, short ob)
{
	Elist *e;
	e=(Elist*)0;

	if (find_event(dialog,ob,&e))
	{
		return e->redraw;
	}else{
		return 0;
	}
}

short Set_object_redraw(short dialog, short ob, CallBack c)
{
	Elist *n;
	n=(Elist*)0;
	
	if (!find_event(dialog,ob,&n))
	{
		n=(Elist*)malloc(sizeof(Elist));
		n->object=ob;
		n->next=event_value[dialog];
		event_value[dialog]=n;
		n->this_event=0;
		n->this_devent=0;
		n->callback=(CallBack)0;
		n->dcallback=NULL;
		n->stext.texts=NULL;
	}

	n->redraw=c;
	
	return 0;
}

short find_event(short dialog,short ob, Elist *ee[])
{
	short o;
	Elist *e;
	
	o=ob-1;
	e=event_value[dialog];
	if (e!=(Elist*)0)
	{
		for(o=e->object; (e!=(Elist*)0)&&(o!=ob); )
		{
			o=e->object;
			if (o!=ob) { e=e->next; }
		}
	}
	
	ee[0]=e;
	
	if (o!=ob)
	{
		return 0;
	} else {
		return 1;
	}
}
