/*
  DU_LIB v2
  Gem Window Management & Dialog Library For Lattice C
  1994, by Craig Graham.
  
  Based on the DU_LIBv1 Library for HiSoft Basic.
*/

/*
  Windowed Dialog Handlers
*/

#include "dulib.h"

/*==========================================
 = Open a non-blocking dialog in a window  =
 =  21/8/1994, Craig Graham                =
 ===========================================*/

short activate_dialog(short dialog, char *n, dialog_type t)
{
	OBJECT *a;
	short x,y,rx,ry,rw,rh;
	short wh,tp;
	Wtype wt;

/* Is tool bar already open ? - if so, then top it. */
	x=-1;
	for (y=0; y<50;y++)
	{
		if ((windows[y].window_type==wt_dialog) && (windows[y].the_dialog==dialog))
		{
			x=y;
		}
	}
	
	if (x!=-1)
	{
		wind_set(x,WF_TOP,0,0,0,0);
		return 1;
	}else{
/* Get size of dialog */
		rsrc_gaddr(0,dialog,&a);
		rx=ry=rw=rh=0;
		form_center(a,&rx,&ry,&rw,&rh);
		wt=wt_dialog;
/*Open the window*/
		switch (t)
		{
			case DIAL_FIXED:
			{
				tp=NAME;
				wt=wt_static_menu;
				break;
			}
			case DIAL_NO_CLOSE:
			{
				tp=NAME+MOVER;
				tp=9;
				wt=wt_null;
				break;
			}
			case DIAL_WIDGET_BAR:
			{
				tp=NAME+CLOSER+FULLER+MOVER+SIZER+UPARROW+DNARROW+VSLIDE+LFARROW+RTARROW+HSLIDE;
				wt=wt_drawing;
				break;
			}
			case DIAL_ROLLUP:
			{
				tp=NAME+CLOSER+FULLER+MOVER;
				wt=wt_dialog;
			}
		}
		wind_calc(0,tp,rx,ry,rw,rh,&x,&y,&rw,&rh);
		if (tp==1)
		{
			wh=wind_create(tp,scrn_x,scrn_y,rw,rh);
		} else {
			wh=wind_create(tp,x,y,rw,rh);
		}

		wind_set(wh,WF_NAME, ADDR(n));

		if (tp==1)
		{
			wind_open(wh,scrn_x,scrn_y,rw,rh);
		} else {
			wind_open(wh,x,y,rw,rh);
		}
		
		windows[wh].window_type=wt;
		windows[wh].the_dialog=dialog;
		windows[wh].redraw_mode=wrm_window;

		udw=0;

		display_dial(wh);
		last_opened_window=wh;

		return wh;
	}
}

/*==============================
   Close a Dialog Window
  ==============================*/
short close_dialog(short e_wind)
{
	windows[e_wind].the_dialog=0;
	windows[e_wind].window_type=wt_null;
	
	graf_mouse(M_OFF,NULL);
	wind_close(e_wind);
	wind_delete(e_wind);
	graf_mouse(M_ON,NULL);
	return 0;
}

short set_window_title(short h, char *a)
{
	wind_set(h,WF_NAME,ADDR(a));
	return 0;
}

/*===========================================
  = Display a win_dialog window (clipped)   =
  ===========================================*/
short display_dial(short wind_handle)
{
	short x,y,w,h;
	short rw,rh,dialog,rx,ry;
	short dx,dy,dw,dh;
	short cb;
	OBJECT *a;

	cb=wmi_total_buffering;
	wmi_total_buffering=0;
	
	dx=dy=dw=dh=0;
	
/*	vst_point(12);*/

	dialog=windows[wind_handle].the_dialog;

	rsrc_gaddr(0,dialog,&a);
	wind_get(wind_handle,WF_WORKXYWH,&x,&y,&w,&h);

	if (h!=0)
	{
		a->ob_x=x;
		a->ob_y=y;

		graf_mouse(M_OFF,NULL);
		wind_update(BEG_UPDATE);

		wind_get(wind_handle,WF_FIRSTXYWH,&rx,&ry,&rw,&rh);
		while (rw>0 && rh>0)
		{
			dx=rx;dy=ry;dw=rw;dh=rh;
			if (udw!=0)
			{
				if (intersection(rx,ry,rw,rh,udx,udy,udw,udh,&dx,&dy,&dw,&dh))
				{
					cr_dclip.g_x=dx;
					cr_dclip.g_y=dy;
					cr_dclip.g_w=dw;
					cr_dclip.g_h=dh;
					objc_draw(a,0,5,dx,dy,dw,dh);
					redraw_custom(wind_handle);
				}
			}
			
			wind_get(wind_handle,WF_NEXTXYWH,&rx,&ry,&rw,&rh);
		}

		wind_update(END_UPDATE);
		graf_mouse(M_ON,NULL);

	}
	
	wmi_total_buffering=cb;	
	return 0;
}

/*=========================================================================
  = Re-display only the custom objects in a win_dialog window (clipped)   =
  =========================================================================*/
short custom_display_dial(short wind_handle)
{
	short wx,wy,ww,wh;
	short rw,rh,dialog,rx,ry;
	short dx,dy,dw,dh;
	short cb;
	OBJECT *a;
	short clip[4];
	CallBack rd;
	Elist *e;
	GRECT r;
#ifdef __USE_GNU
	short x,y;
#endif	

	cb=wmi_total_buffering;
	wmi_total_buffering=0;
	
	dx=dy=dw=dh=0;
	
	dialog=windows[wind_handle].the_dialog;
	this_dialog=dialog;
	cr_wind_handle=wind_handle;

	rsrc_gaddr(0,dialog,&a);
	wind_get(wind_handle,WF_WORKXYWH,&wx,&wy,&ww,&wh);

	if (wh!=0)
	{
		a->ob_x=wx;
		a->ob_y=wy;

		graf_mouse(M_OFF,NULL);
		wind_update(BEG_UPDATE);

		wind_get(wind_handle,WF_FIRSTXYWH,&rx,&ry,&rw,&rh);
		while (rw>0 && rh>0)
		{
			dx=rx;dy=ry;dw=rw;dh=rh;
			if (udw!=0)
			{
				if (intersection(rx,ry,rw,rh,udx,udy,udw,udh,&dx,&dy,&dw,&dh))
				{
					cr_dclip.g_x=dx;
					cr_dclip.g_y=dy;
					cr_dclip.g_w=dw;
					cr_dclip.g_h=dh;
	
					r=cr_dclip;
	
					e=event_value[dialog];
					if (e!=0)
					{
						for(; e!=0; e=e->next)
						{
							rd=e->redraw;
							if (rd)
							{
								this_ob=e->object;
#ifndef __USE_GNU
								objc_xywh(a,this_ob,&cr_clip);
#else
								objc_offset(a,this_ob,&x,&y);
								cr_clip.g_x=x;
								cr_clip.g_y=y;
								cr_clip.g_w=(a+this_ob)->ob_width;
								cr_clip.g_h=(a+this_ob)->ob_height;
#endif
								cr_dclip=r;
								rc_intersect(&cr_clip,&cr_dclip);
								clip[0]=cr_dclip.g_x, clip[1]=cr_dclip.g_y;
								clip[2]=cr_dclip.g_x+cr_dclip.g_w-1; clip[3]=cr_dclip.g_y+cr_dclip.g_h-1;
								vs_clip(x_handle,1,clip);
								objc_draw(a,this_ob,1,dx,dy,dw,dh);
								(*rd)();
							}
						}
					}
				}
			}
			
			wind_get(wind_handle,WF_NEXTXYWH,&rx,&ry,&rw,&rh);
		}

		wind_update(END_UPDATE);
		graf_mouse(M_ON,NULL);

	}
	
	wmi_total_buffering=cb;	
	return 0;
}

/*====================================================================================
  = Re-display only the a specified custom object in a win_dialog window (clipped)   =
  ====================================================================================*/
short custom_display_object(short wind_handle, short ob)
{
	short wx,wy,ww,wh;
	short rw,rh,dialog,rx,ry;
	short dx,dy,dw,dh;
	short cb;
	OBJECT *a;
	short clip[4];
	CallBack rd;
	Elist *e;
	GRECT r;
#ifdef __USE_GNU
	short x,y;
#endif	

	cb=wmi_total_buffering;
	wmi_total_buffering=0;
	
	dx=dy=dw=dh=0;
	
	dialog=windows[wind_handle].the_dialog;
	this_dialog=dialog;
	cr_wind_handle=wind_handle;

	rsrc_gaddr(0,dialog,&a);
	wind_get(wind_handle,WF_WORKXYWH,&wx,&wy,&ww,&wh);

	if (wh!=0)
	{
		a->ob_x=wx;
		a->ob_y=wy;

		graf_mouse(M_OFF,NULL);
		wind_update(BEG_UPDATE);

		wind_get(wind_handle,WF_FIRSTXYWH,&rx,&ry,&rw,&rh);
		while (rw>0 && rh>0)
		{
			dx=rx;dy=ry;dw=rw;dh=rh;
			if (udw!=0)
			{
				if (intersection(rx,ry,rw,rh,udx,udy,udw,udh,&dx,&dy,&dw,&dh))
				{
					cr_dclip.g_x=dx;
					cr_dclip.g_y=dy;
					cr_dclip.g_w=dw;
					cr_dclip.g_h=dh;
	
					r=cr_dclip;
	
					this_ob=ob;
					objc_draw(a,this_ob,0,dx,dy,dw,dh);

					e=event_value[dialog];
					if (e!=0)
					{
						for(; e!=0; e=e->next)
						{
							rd=e->redraw;
							if (ob==e->object)
							{
#ifndef __USE_GNU
								objc_xywh(a,this_ob,&cr_clip);
#else
								objc_offset(a,this_ob,&x,&y);
								cr_clip.g_x=x;
								cr_clip.g_y=y;
								cr_clip.g_w=(a+this_ob)->ob_width;
								cr_clip.g_h=(a+this_ob)->ob_height;
#endif
								cr_dclip=r;
								rc_intersect(&cr_clip,&cr_dclip);
								clip[0]=cr_dclip.g_x, clip[1]=cr_dclip.g_y;
								clip[2]=cr_dclip.g_x+cr_dclip.g_w-1; clip[3]=cr_dclip.g_y+cr_dclip.g_h-1;
								vs_clip(x_handle,1,clip);
								if (rd) (*rd)();
							}
						}
					}
				}
			}
			
			wind_get(wind_handle,WF_NEXTXYWH,&rx,&ry,&rw,&rh);
		}

		wind_update(END_UPDATE);
		graf_mouse(M_ON,NULL);

	}
	
	wmi_total_buffering=cb;	
	return 0;
}

int intersection(short x1,short y1,short w1,short h1,short x2,short y2,short w2,short h2,short *x,short *y,short *w,short *h)
{
	GRECT a,b;
	int r;
	
	a.g_x=x2; a.g_y=y2; a.g_w=w2; a.g_h=h2;
	b.g_x=x1; b.g_y=y1; b.g_w=w1; b.g_h=h1;
	
	r=rc_intersect(&a,&b);
	
	*x=b.g_x; *y=b.g_y; *w=b.g_w; *h=b.g_h;
	return r;
}

/* Update a dialog (if it is open)*/
short dialog_update(short d)
{
	short n,rtn;
	rtn=0;
	for(n=0; n<50;n++)
	{
		if (((((((windows[n].window_type==wt_dialog))||(windows[n].window_type==wt_drawing))||(windows[n].window_type==wt_static_menu))||(windows[n].window_type==wt_menu_bar))||(windows[n].window_type==wt_iconified_drawing))&&(windows[n].the_dialog==d))
		{ 
			rtn=update_window(n); 
		}
	}
	return rtn;
}

int redraw_custom(short wind_handle)
{
	OBJECT *a;
	short clip[4];
	CallBack rd;
	short dialog;
	Elist *e;
	GRECT r;
#ifdef __USE_GNU
	short x,y;
#endif	
	
	dialog=windows[wind_handle].the_dialog;
	rsrc_gaddr(0,dialog,&a);

	this_dialog=dialog;
	cr_wind_handle=wind_handle;
	r=cr_dclip;
	
	e=event_value[dialog];
	if (e!=0)
	{
		for(; e!=0; e=e->next)
		{
			rd=e->redraw;
			if (rd)
			{
				this_ob=e->object;
#ifndef __USE_GNU
				objc_xywh(a,this_ob,&cr_clip);
#else
				objc_offset(a,this_ob,&x,&y);
				cr_clip.g_x=x;
				cr_clip.g_y=y;
				cr_clip.g_w=(a+this_ob)->ob_width;
				cr_clip.g_h=(a+this_ob)->ob_height;
#endif
				cr_dclip=r;
				rc_intersect(&cr_clip,&cr_dclip);
				clip[0]=cr_dclip.g_x, clip[1]=cr_dclip.g_y;
				clip[2]=cr_dclip.g_x+cr_dclip.g_w-1; clip[3]=cr_dclip.g_y+cr_dclip.g_h-1;
				vs_clip(x_handle,1,clip);
				(*rd)();
			}
		}
	}

	return 0;
}

/*==================================================================
  = Perform processing on a dialog in a window.                    =
  =  When passed an MU_BUTTON event for a dialog window, this      =
  =  will perfrom processing on that dialog (radio buttons, etc)   =
  =  and will return 0 if the dialog did NOT exit, else the object =
  =  number exitted on.                                            =
  ==================================================================*/

short process_win_dial(short wh,short x,short y)
{
	short ob,mb,Obflags,Obtype,Obstate,dx,dy;
	short a,rtn,ReallySelected;
	short clip[4];
	OBJECT *TheDial;
	CallBack custom_handler;
	CallBack dcustom_handler;
	CallBack rd;
#ifdef __USE_GNU
	short cx,cy;
#endif

	rtn=0; mb=0;
	a=windows[wh].the_dialog;
	this_dialog=a;
	cr_wind_handle=wh;
	
	rsrc_gaddr(0,a,&TheDial);							/*Address of dialog in resource*/

	wind_get(wh,WF_WORKXYWH,&dx,&dy,&junk,&junk);		/*Ensure that the dialog is where we think it is          */
	TheDial->ob_x=dx;									/* (fix for multiple copies of a dialog (eg a widget bar) */
	TheDial->ob_y=dy;

	ob=objc_find(TheDial, 0, 5, x, y);					/*Find the object clicked on*/
	Get_ob_info(TheDial,ob,&Obtype,&Obflags,&Obstate);

	if (ob>0)
	{
		custom_handler=Get_object_callback(a, ob);		/*Check for a custom object handler (single click)*/
		dcustom_handler=Get_object_dcallback(a, ob);	/*Check for a custom object handler (double click)*/
		if ((custom_handler!=0)||(dcustom_handler!=0))	/*If there is one use it, else use the generic behaviour*/
		{
			this_ob=ob;
#ifndef __USE_GNU
			objc_xywh(TheDial,this_ob,&cr_clip);
#else
			objc_offset(TheDial,this_ob,&cx,&cy);
			cr_clip.g_x=cx;
			cr_clip.g_y=cy;
			cr_clip.g_w=(TheDial+this_ob)->ob_width;
			cr_clip.g_h=(TheDial+this_ob)->ob_height;
#endif
			cr_mx=x-cr_clip.g_x;
			cr_my=y-cr_clip.g_y;
			rd=Get_object_redraw(a,ob);
			if (!rd) objc_change(TheDial,ob,0,scrn_x,scrn_y,scrn_w,scrn_h,(Obstate|mask_selected),1);

			clip[0]=scrn_x; clip[1]=scrn_y; clip[2]=scrn_x+scrn_w-1; clip[3]=scrn_y+scrn_h-1;
			vs_clip(x_handle,1,clip);

			if ((click_count==2)&&(dcustom_handler!=0))
			{
				if ((*dcustom_handler)()) rtn=ob;
			}else{
				if ((Obflags & mask_rbutton)==mask_rbutton)
				{
					Radio_b(TheDial,ob);
					do
					{
						graf_mkstate(&junk,&junk,&mb,&junk);
					}
					while (mb!=0);
				}
			}

			if ((click_count==1)&&(custom_handler!=0))
				if ((*custom_handler)()) rtn=ob;
			
			if ((rd==NULL)&&((Obflags & mask_rbutton)!=mask_rbutton)) objc_change(TheDial,ob,0,scrn_x,scrn_y,scrn_w,scrn_h,Obstate & !mask_selected,1);
			if ((rd!=NULL)&&((Obflags & mask_selectable)==mask_selectable)) (*rd)();
/*			Obflags=0;*/
		} 

		if (!rtn)												/*default behaviour*/
		{
			if ((Obflags&mask_selectable)==mask_selectable)		/* Is this a selectable object ?*/
			{
				if ((Obflags & mask_rbutton)!=mask_rbutton)
				{
					do
					{
						graf_mkstate(&junk,&junk,&mb,&junk);
						ReallySelected=graf_watchbox(TheDial,ob,1,0);
					}
					while (mb!=0);
					if (ReallySelected)
					{
						if ((Obstate & mask_selected)==mask_selected)
						{
							objc_change(TheDial,ob,0,scrn_x,scrn_y,scrn_w,scrn_h,Obstate & !mask_selected,1);
						} else {
							objc_change(TheDial,ob,0,scrn_x,scrn_y,scrn_w,scrn_h,Obstate | mask_selected,1);
						}
					} else {
						objc_change(TheDial,ob,0,scrn_x,scrn_y,scrn_w,scrn_h,Obstate & !mask_selected,1);
						Obflags=Obflags & !mask_exit;
					}
				} else {
					Radio_b(TheDial,ob);
					do
					{
						graf_mkstate(&junk,&junk,&mb,&junk);
					}
					while (mb!=0);
				}
			}
		}
	}
	
	if ((Obflags & mask_exit)==mask_exit)
	{
		if ((Obflags & mask_rbutton)!=mask_rbutton)
			objc_change(TheDial, ob, 0, scrn_x, scrn_y, scrn_w, scrn_h, Obstate & !mask_selected, 1);
		rtn=ob;
	}
	return rtn;
}

/*
  Sets one of a group of radio buttons, and clears the rest.
  Includes patch to allow for pop_icons as radio buttons.
*/
short Radio_b(OBJECT *t, short object)
{
	OBJECT *obloc;
	short m,parent,o,tobs;

	parent=GetParent(t,object);
	tobs=this_ob;
	
	udx=scrn_x; udy=scrn_y;
	udw=scrn_w; udh=scrn_h;
	
	obloc=t+parent;
	o=obloc->ob_head;
	obloc=t+o;
	while ((o!=parent)&&(o!=-1))
	{
		if (obloc->ob_flags & mask_rbutton==mask_rbutton)
		{
			obloc->ob_state=obloc->ob_state & !mask_selected;
		}
		o=obloc->ob_next;
		obloc=t+o;
	}
	obloc=t+object;
	obloc->ob_state=obloc->ob_state | mask_selected;

	for(m=0; m<max_windows; m++)					/*redraw the parent of this radio button group*/
	{
		if ((windows[m].window_type!=wt_null)&&(windows[m].the_dialog==this_dialog))
		{
			custom_display_object(m,parent);
		}
	}

	obloc=t+parent;
	o=obloc->ob_head;
	obloc=t+o;
	while ((o!=parent)&&(o!=-1))
	{
		if (obloc->ob_flags & mask_rbutton==mask_rbutton)
		{
			this_ob=o;
			for(m=0; m<max_windows; m++)					/*Send redraw messages to all our other windows*/
			{
				if ((windows[m].window_type!=wt_null)&&(windows[m].the_dialog==this_dialog))
				{
					custom_display_object(m,o);
				}
			}
		}
		o=obloc->ob_next;
		obloc=t+o;
	}

	this_ob=tobs;
	return 0;
}

/* Returns the object number of this object's parent or -1 if it is the root*/
short GetParent(OBJECT *t,short object)
{
	short nextobject,n_ob_tail;
	OBJECT* c_obl;
	OBJECT* n_obl;
	
	if (object==0)
	{
		return -1;
	} else {
		do
		{
			c_obl=t+object;
			nextobject=c_obl->ob_next;
			n_obl=t+nextobject;
			n_ob_tail=n_obl->ob_tail;
			if (n_ob_tail!=object) { object=nextobject; }
		}
		while (n_ob_tail!=object);
		return nextobject;
	}
}

/* Returns the value of the ob_state,ob_type & ob_flags fields in the given object */
short Get_ob_info(OBJECT *dialog,short ob,short *otype,short *oflags,short *ostate)
{
	OBJECT *a;
	a=dialog+ob;
	*oflags=a->ob_flags;
	*otype=a->ob_type;
	*ostate=a->ob_state;
	return 0;
}

