/*
  DU_LIB v2
  Gem Window Management & Dialog Library For Lattice C
  1994, by Craig Graham.
  
  Based on the DU_LIBv1 Library for HiSoft Basic.
*/

/*
	Icon Popup Handler
*/

#include "DULIB.H"

void Set_icon_popup(short dialog, short object, short p_form)
{
	Elist *n;
	n=(Elist*)0;

	Set_object_redraw(dialog,object,&display_p_icon);				/*customise the redraw*/
	Set_object_dcallback(dialog,object,&do_icon_popup);				/*double click pops up the menu*/

	find_event(dialog,object,&n);
	n->popup_form=p_form;
	n->popup_icon_current=1;

}

short Get_icon_popup(short dialog, short object)
{
	Elist *n;

	n=(Elist*)0;
	find_event(dialog,object,&n);
	if (n)
	{
		return n->popup_icon_current;
	} else {
		return 0;
	}

}

short display_p_icon(void)
{
	OBJECT *a;
	OBJECT *parent;
	Elist *n;
	
	n=(Elist*)0;

	find_event(this_dialog,this_ob,&n);
	
	rsrc_gaddr(0,n->popup_form,&a);				/*find icon popup form*/
	rsrc_gaddr(0,this_dialog,&parent);			/*find dialog containing hot icon*/
	objc_draw(parent,this_ob,1,cr_dclip.g_x,cr_dclip.g_y,cr_dclip.g_w,cr_dclip.g_h);
	parent=parent+this_ob;
	
	(a+(n->popup_icon_current))->ob_x=0;		/*current icon to origin in dial*/
	(a+(n->popup_icon_current))->ob_y=0;
	a->ob_x=cr_clip.g_x;						/*form to required redraw location*/
	a->ob_y=cr_clip.g_y;
	(a+(n->popup_icon_current))->ob_state=parent->ob_state;
	
	objc_draw(a,n->popup_icon_current,1,cr_dclip.g_x,cr_dclip.g_y,cr_dclip.g_w,cr_dclip.g_h);

	return 0;
}

short do_icon_popup(void)
{	
	OBJECT *a;
	OBJECT *s;
	short maxh,px,m;
	Elist *n;
	MFDB scr,obm;
	short p[8];
	short *buf;
	
	n=(Elist*)0;

	find_event(this_dialog,this_ob,&n);

	maxh=0; px=2;
	rsrc_gaddr(0,n->popup_form,&a);				/*find icon popup form*/
	
	for (s=a+1; s!=a; s=a+s->ob_next)
	{
		if (s->ob_height > maxh) maxh=s->ob_height;
		s->ob_x=px;
		s->ob_y=2;
		s->ob_state=s->ob_state & !mask_selected;
		px=px+s->ob_width+4;
	}
	a->ob_x=cr_clip.g_x-2;						/*form to required redraw location*/
	a->ob_y=cr_clip.g_y-2;
	a->ob_height=maxh+4;
	a->ob_width=px-2;

	buf=(short*)malloc(((scrn_planes*(a->ob_width+6))/4)*(a->ob_height+5));

	if (buf)
	{
		scr.fd_addr=NULL;

		graf_mouse(M_OFF,NULL);

		obm.fd_addr=buf;
		obm.fd_w=a->ob_width+4;
		obm.fd_h=a->ob_height+4;
		obm.fd_wdwidth=(short)(obm.fd_w/8);
		obm.fd_stand=1;
		obm.fd_nplanes=scrn_planes;

		p[0]=a->ob_x; p[1]=a->ob_y;
		p[2]=p[0]+a->ob_width; p[3]=p[1]+a->ob_height;
		p[4]=p[5]=1;
		p[6]=p[4]+a->ob_width; p[7]=p[5]+a->ob_height;
		vro_cpyfm(x_handle,S_ONLY,p,&scr,&obm);
	
		objc_draw(a,0,2,scrn_x,scrn_y,scrn_w,scrn_h);

		graf_mouse(M_ON,NULL);
		n->popup_icon_current=form_do(a,0);
		graf_mouse(M_OFF,NULL);

		scr.fd_addr=NULL;
		p[0]=p[1]=1;
		p[2]=p[0]+a->ob_width; p[3]=p[1]+a->ob_height;
		p[4]=a->ob_x; p[5]=a->ob_y;
		p[6]=p[4]+a->ob_width; p[7]=p[5]+a->ob_height;
		vro_cpyfm(x_handle,S_ONLY,p,&obm,&scr);

		a=a+n->popup_icon_current;
	
		rsrc_gaddr(0,this_dialog,&s);				/*find icon popup form*/
		s=s+this_ob;
		a->ob_state=s->ob_state;

		graf_mouse(M_ON,NULL);

		free(buf);

		for(m=0; m<max_windows; m++)					/*Send redraw messages to all our other windows*/
		{
			if ((windows[m].window_type!=wt_null)&&(windows[m].the_dialog==this_dialog))
			{
				custom_display_object(m,this_ob);
			}
		}

		return 1;
	} else {
		form_alert(1,"[3][ | DULIB GUI ERROR: | Out of memory for icon popup | background buffering. ][ Cancel ]");
		return 0;
	}
}
