#include "util.h"
#include "lancemem.h"
#include "pktqueue.h"

#ifndef NULL
#define NULL (void *)0L
#endif

#define FALSE 0
#define TRUE  1 


PKTPOOL *p_init(int npkt,PKTPOOL *p_pool,PKTBUF *p_buf)
{
register int i;

	if(!p_pool) return(NULL);
	p_pool->p_get = p_pool->p_put = 0;
	p_pool->p_nbuf = npkt;
	for(i=0; i<npkt; i++)
	{
		p_pool->p_tab[i].p_occupied = FALSE;
		p_pool->p_tab[i].p_pkt = p_buf+i;
	}
	return(p_pool);
}

PKTBUF *ap_getpkt(u_short protocol, PKTPOOL *p_pool)
{
PKTBUF *pkt;
	short sr = spl7 ();
	pkt=p_getpkt(protocol,p_pool);
	spl (sr);
	return(pkt);
}


PKTBUF *p_getpkt(u_short protocol, PKTPOOL *p_pool)
{
register int i;

	if(!p_pool) return(NULL);
	i = p_pool->p_get;
	if(p_pool->p_tab[i].p_occupied) return(NULL);
	p_pool->p_get++;
	if(p_pool->p_get >= p_pool->p_nbuf) p_pool->p_get = 0;
	p_pool->p_tab[i].p_occupied = protocol;
	return(p_pool->p_tab[i].p_pkt);
}

int ap_putpkt(PKTPOOL *p_pool,PKTBUF *pkt)
{
int r;
	short sr = spl7 ();
	r=p_putpkt(p_pool,pkt);
	spl (sr);
	return(r);
}


int p_putpkt(PKTPOOL *p_pool,PKTBUF *pkt)
{
register int i;

	if(!p_pool) return(FALSE);
	i = p_pool->p_put;
	if(!p_pool->p_tab[i].p_occupied)
	{
		return(FALSE);
	}
	p_pool->p_put++;
	if(p_pool->p_put >= p_pool->p_nbuf) p_pool->p_put = 0;
	p_pool->p_tab[i].p_pkt = pkt;
	p_pool->p_tab[i].p_occupied = FALSE;
	return(TRUE);
}
