/*
 *	10 Mbit Ethernet support functions, exported to packet drivers
 *	through struct netinfo.
 *
 *	12/14/94, Kay Roemer.
 */

#include <string.h>
#include "config.h"
#include "kerbind.h"
#include "buf.h"
#include "if.h"
#include "ifeth.h"

BUF *
eth_build_hdr (buf, nif, addr, type)
	BUF *buf;
	struct netif *nif;
	char *addr;
	short type;
{
	struct eth_dgram *ep;
	BUF *nbuf;
	long len;

	len = buf->dend - buf->dstart;
	if (len > ETH_MAX_DLEN) {
		buf_deref (buf, BUF_NORMAL);
		return 0;
	}
	nbuf = buf_reserve (buf, sizeof (*ep), BUF_RESERVE_START);
	if (!nbuf) {
		buf_deref (buf, BUF_NORMAL);
		return 0;
	}
	buf->dstart -= sizeof (*ep);
	ep = (struct eth_dgram *)buf->dstart;
	memcpy (ep->saddr, nif->hwlocal.addr, ETH_ALEN);
	memcpy (ep->daddr, addr, ETH_ALEN);
	ep->proto = (type == ETHPROTO_8023) ? (short)len : type;
	return nbuf;
}

short
eth_remove_hdr (buf)
	BUF *buf;
{
	struct eth_dgram *ep = (struct eth_dgram *)buf->dstart;
	short type;

	type = (ep->proto >= 1536) ? ep->proto : ETHPROTO_8023;
	buf->dstart += sizeof (*ep);
	return type;
}
