#ifndef _IFETH_H
#define _IFETH_H

#define ETH_ALEN	6	/* HW addr length */
#define ETH_HLEN	14	/* Eth frame header length */
#define ETH_MIN_DLEN	46	/* minimum data length */
#define ETH_MAX_DLEN	1500	/* maximum data length */

#define ETHPROTO_LOOP	0x0060	/* Eth loopback frame */
#define ETHPROTO_ECHO	0x0200	/* Eth echo frame */
#define ETHPROTO_IP	0x0800	/* IP frame */
#define ETHPROTO_ARP	0x0806	/* ARP frame */
#define ETHPROTO_RARP	0x8035	/* reverse ARP frame */

struct eth_dgram {
	unsigned char	daddr[ETH_ALEN];
	unsigned char	saddr[ETH_ALEN];
	unsigned short	proto;
	unsigned char	data[0];
};

#endif
